/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.protobuf;

import com.google.protobuf.MessageLite;
import io.seata.common.exception.ShouldNeverHappenException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProtobufHelper {
    ConcurrentMap<Class, Method> parseFromMethodMap = new ConcurrentHashMap<Class, Method>();
    ConcurrentMap<Class, Method> toByteArrayMethodMap = new ConcurrentHashMap<Class, Method>();
    private ConcurrentMap<String, Class> requestClassCache = new ConcurrentHashMap<String, Class>();

    public Class getPbClass(String clazzName) {
        Class reqClass = (Class)this.requestClassCache.get(clazzName);
        if (reqClass == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new ShouldNeverHappenException("get class occurs exception", e);
            }
            this.loadProtoClassToCache(clazzName, clazz);
        }
        return (Class)this.requestClassCache.get(clazzName);
    }

    private void loadProtoClassToCache(String key, Class clazz) {
        if (clazz == Void.TYPE || !this.isProtoBufMessageClass(clazz)) {
            throw new ShouldNeverHappenException("class based protobuf: " + clazz.getName() + ", only support return protobuf message!");
        }
        this.requestClassCache.put(key, clazz);
    }

    boolean isProtoBufMessageClass(Class clazz) {
        return clazz != null && MessageLite.class.isAssignableFrom(clazz);
    }
}

