/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.mysql;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.KeywordChecker;
import io.seata.rm.datasource.undo.KeywordCheckerFactory;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MySQLUndoDeleteExecutor
extends AbstractUndoExecutor {
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (%s) VALUES (%s)";

    public MySQLUndoDeleteExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        KeywordChecker keywordChecker = KeywordCheckerFactory.getKeywordChecker("mysql");
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (beforeImageRows == null || beforeImageRows.size() == 0) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        ArrayList<Field> fields = new ArrayList<Field>(row.nonPrimaryKeys());
        Field pkField = row.primaryKeys().get(0);
        fields.add(pkField);
        String insertColumns = fields.stream().map(field -> keywordChecker.checkAndReplace(field.getName())).collect(Collectors.joining(", "));
        String insertValues = fields.stream().map(field -> "?").collect(Collectors.joining(", "));
        return String.format(INSERT_SQL_TEMPLATE, keywordChecker.checkAndReplace(this.sqlUndoLog.getTableName()), insertColumns, insertValues);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

