/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xPool;
import io.vertx.core.http.impl.Http2Pool;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.Waiter;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.ProxyChannelProvider;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLHandshakeException;

public class ConnectionManager {
    static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final QueueManager wsQM = new QueueManager();
    private final QueueManager requestQM = new QueueManager();
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final HttpClientOptions options;
    private final HttpClientImpl client;
    private final boolean keepAlive;
    private final boolean pipelining;
    private final int maxWaitQueueSize;
    private final int http2MaxConcurrency;
    private final boolean logEnabled;
    private final ChannelConnector connector;
    private final HttpClientMetrics metrics;

    ConnectionManager(HttpClientImpl client, HttpClientMetrics metrics) {
        this.client = client;
        this.sslHelper = client.getSslHelper();
        this.options = client.getOptions();
        this.vertx = client.getVertx();
        this.keepAlive = client.getOptions().isKeepAlive();
        this.pipelining = client.getOptions().isPipelining();
        this.maxWaitQueueSize = client.getOptions().getMaxWaitQueueSize();
        this.http2MaxConcurrency = this.options.getHttp2MultiplexingLimit() < 1 ? Integer.MAX_VALUE : this.options.getHttp2MultiplexingLimit();
        this.logEnabled = client.getOptions().getLogActivity();
        this.connector = new ChannelConnector();
        this.metrics = metrics;
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    public void getConnectionForWebsocket(boolean ssl, int port, String host, Waiter waiter) {
        ConnQueue connQueue = this.wsQM.getConnQueue(host, ssl, port, host, HttpVersion.HTTP_1_1);
        connQueue.getConnection(waiter);
    }

    public void getConnectionForRequest(HttpVersion version, String peerHost, boolean ssl, int port, String host, Waiter waiter) {
        if (!this.keepAlive && this.pipelining) {
            waiter.handleFailure(new IllegalStateException("Cannot have pipelining with no keep alive"));
        } else {
            ConnQueue connQueue = this.requestQM.getConnQueue(peerHost, ssl, port, host, version);
            connQueue.getConnection(waiter);
        }
    }

    public void close() {
        this.wsQM.close();
        this.requestQM.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    private class ChannelConnector {
        private ChannelConnector() {
        }

        protected void connect(final ConnQueue queue, Bootstrap bootstrap, final ContextImpl context, final String peerHost, boolean ssl, HttpVersion version, String host, final int port, Waiter waiter) {
            this.applyConnectionOptions(ConnectionManager.this.options, bootstrap);
            ChannelProvider channelProvider = ConnectionManager.this.options.getProxyOptions() == null || !ssl && ConnectionManager.this.options.getProxyOptions().getType() == ProxyType.HTTP ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
            boolean useAlpn = ConnectionManager.this.options.isUseAlpn();
            Handler<Channel> channelInitializer = ch -> {
                final ChannelPipeline pipeline = ch.pipeline();
                if (ssl) {
                    SslHandler sslHandler = new SslHandler(ConnectionManager.this.sslHelper.createEngine(ConnectionManager.this.client.getVertx(), peerHost, port, ConnectionManager.this.options.isForceSni() ? peerHost : null));
                    ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
                    sslHandler.handshakeFuture().addListener(fut -> {
                        if (fut.isSuccess()) {
                            String protocol = sslHandler.applicationProtocol();
                            if (useAlpn) {
                                if ("h2".equals(protocol)) {
                                    this.applyHttp2ConnectionOptions(ch.pipeline());
                                    queue.http2Connected(context, ch, waiter, false);
                                } else {
                                    this.applyHttp1xConnectionOptions(ch.pipeline(), context);
                                    HttpVersion fallbackProtocol = "http/1.0".equals(protocol) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                                    queue.fallbackToHttp1x(ch, context, fallbackProtocol, port, host, waiter);
                                }
                            } else {
                                this.applyHttp1xConnectionOptions(ch.pipeline(), context);
                                queue.http1xConnected(version, context, port, host, ch, waiter);
                            }
                        } else {
                            queue.handshakeFailure(context, ch, fut.cause(), waiter);
                        }
                    });
                } else if (version == HttpVersion.HTTP_2) {
                    if (ConnectionManager.this.options.isHttp2ClearTextUpgrade()) {
                        final HttpClientCodec httpCodec = new HttpClientCodec();
                        VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(ConnectionManager.this.client.getOptions().getInitialSettings(), (Channel)ch, waiter){
                            final /* synthetic */ Channel val$ch;
                            final /* synthetic */ Waiter val$waiter;
                            {
                                this.val$ch = channel;
                                this.val$waiter = waiter;
                                super(settings);
                            }

                            @Override
                            public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                                ChannelConnector.this.applyHttp2ConnectionOptions(pipeline);
                                queue.http2Connected(context, this.val$ch, this.val$waiter, true);
                            }
                        };
                        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
                        class UpgradeRequestHandler
                        extends ChannelInboundHandlerAdapter {
                            final /* synthetic */ Channel val$ch;
                            final /* synthetic */ ContextImpl val$context;
                            final /* synthetic */ ConnQueue val$queue;
                            final /* synthetic */ String val$host;
                            final /* synthetic */ Waiter val$waiter;

                            UpgradeRequestHandler() {
                                this.val$ch = channel;
                                this.val$context = contextImpl;
                                this.val$queue = connQueue;
                                this.val$host = string2;
                                this.val$waiter = waiter;
                            }

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
                                String hostHeader = peerHost;
                                if (port != 80) {
                                    hostHeader = hostHeader + ":" + port;
                                }
                                upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostHeader);
                                ctx.writeAndFlush((Object)upgradeRequest);
                                ctx.fireChannelActive();
                            }

                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (msg instanceof LastHttpContent) {
                                    ChannelPipeline p = ctx.pipeline();
                                    p.remove((ChannelHandler)httpCodec);
                                    p.remove((ChannelHandler)this);
                                    ChannelConnector.this.applyHttp1xConnectionOptions(this.val$ch.pipeline(), this.val$context);
                                    this.val$queue.fallbackToHttp1x(this.val$ch, this.val$context, HttpVersion.HTTP_1_1, port, this.val$host, this.val$waiter);
                                }
                            }

                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                super.userEventTriggered(ctx, evt);
                                if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                                    ctx.pipeline().remove((ChannelHandler)this);
                                }
                            }
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{httpCodec, upgradeHandler, new UpgradeRequestHandler()});
                    } else {
                        this.applyHttp2ConnectionOptions(pipeline);
                    }
                } else {
                    this.applyHttp1xConnectionOptions(pipeline, context);
                }
            };
            Handler<AsyncResult<Channel>> channelHandler = res -> {
                if (res.succeeded()) {
                    Channel ch = (Channel)res.result();
                    if (!ssl && ch.pipeline().get(HttpClientUpgradeHandler.class) == null) {
                        if (version == HttpVersion.HTTP_2 && !ConnectionManager.this.options.isHttp2ClearTextUpgrade()) {
                            queue.http2Connected(context, ch, waiter, false);
                        } else {
                            queue.http1xConnected(version, context, port, host, ch, waiter);
                        }
                    }
                } else {
                    queue.connectionFailed(context, null, waiter::handleFailure, res.cause());
                }
            };
            channelProvider.connect(ConnectionManager.this.vertx, bootstrap, ConnectionManager.this.options.getProxyOptions(), SocketAddress.inetSocketAddress(port, host), channelInitializer, channelHandler);
        }

        void applyConnectionOptions(HttpClientOptions options, Bootstrap bootstrap) {
            ConnectionManager.this.vertx.transport().configure(options, bootstrap);
        }

        void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
            if (ConnectionManager.this.options.getIdleTimeout() > 0) {
                pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, ConnectionManager.this.options.getIdleTimeout()));
            }
        }

        void applyHttp1xConnectionOptions(ChannelPipeline pipeline, ContextImpl context) {
            if (ConnectionManager.this.logEnabled) {
                pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
            }
            pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(ConnectionManager.this.options.getMaxInitialLineLength(), ConnectionManager.this.options.getMaxHeaderSize(), ConnectionManager.this.options.getMaxChunkSize(), false, false, ConnectionManager.this.options.getDecoderInitialBufferSize()));
            if (ConnectionManager.this.options.isTryUseCompression()) {
                pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
            }
            if (ConnectionManager.this.options.getIdleTimeout() > 0) {
                pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, ConnectionManager.this.options.getIdleTimeout()));
            }
        }
    }

    static interface Pool<C extends HttpClientConnection> {
        public HttpVersion version();

        public C pollConnection();

        public boolean canCreateConnection(int var1);

        public void closeAllConnections();

        public void recycle(C var1);

        public HttpClientStream createStream(C var1) throws Exception;
    }

    public class ConnQueue {
        private final QueueManager mgr;
        private final String peerHost;
        private final boolean ssl;
        private final int port;
        private final String host;
        private final ConnectionKey key;
        private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();
        private Pool<HttpClientConnection> pool;
        private int connCount;
        private final int maxSize;
        final Object metric;

        ConnQueue(HttpVersion version, QueueManager mgr, String peerHost, String host, int port, boolean ssl, ConnectionKey key) {
            this.key = key;
            this.host = host;
            this.port = port;
            this.ssl = ssl;
            this.peerHost = peerHost;
            this.mgr = mgr;
            if (version == HttpVersion.HTTP_2) {
                this.maxSize = ConnectionManager.this.options.getHttp2MaxPoolSize();
                this.pool = new Http2Pool(this, ConnectionManager.this.client, ConnectionManager.this.metrics, mgr.connectionMap, ConnectionManager.this.http2MaxConcurrency, ConnectionManager.this.logEnabled, ConnectionManager.this.options.getHttp2MaxPoolSize(), ConnectionManager.this.options.getHttp2ConnectionWindowSize());
            } else {
                this.maxSize = ConnectionManager.this.options.getMaxPoolSize();
                this.pool = new Http1xPool(ConnectionManager.this.client, ConnectionManager.this.metrics, ConnectionManager.this.options, this, mgr.connectionMap, version, ConnectionManager.this.options.getMaxPoolSize(), host, port);
            }
            this.metric = ConnectionManager.this.metrics != null ? ConnectionManager.this.metrics.createEndpoint(host, port, this.maxSize) : null;
        }

        public synchronized void getConnection(Waiter waiter) {
            HttpClientConnection conn = this.pool.pollConnection();
            if (conn != null && conn.isValid()) {
                ContextImpl context = waiter.context;
                if (context == null) {
                    context = conn.getContext();
                } else if (context != conn.getContext()) {
                    log.warn("Reusing a connection with a different context: an HttpClient is probably shared between different Verticles");
                }
                context.runOnContext(v -> this.deliverStream(conn, waiter));
            } else if (this.pool.canCreateConnection(this.connCount)) {
                this.createNewConnection(waiter);
            } else if (ConnectionManager.this.maxWaitQueueSize < 0 || this.waiters.size() < ConnectionManager.this.maxWaitQueueSize) {
                if (ConnectionManager.this.metrics != null) {
                    waiter.metric = ConnectionManager.this.metrics.enqueueRequest(this.metric);
                }
                this.waiters.add(waiter);
            } else {
                waiter.handleFailure(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + ConnectionManager.this.maxWaitQueueSize));
            }
        }

        void deliverStream(HttpClientConnection conn, Waiter waiter) {
            if (!conn.isValid()) {
                this.getConnection(waiter);
            } else if (waiter.isCancelled()) {
                this.pool.recycle(conn);
            } else {
                HttpClientStream stream;
                try {
                    stream = this.pool.createStream(conn);
                }
                catch (Exception e) {
                    this.getConnection(waiter);
                    return;
                }
                waiter.handleStream(stream);
            }
        }

        void closeAllConnections() {
            this.pool.closeAllConnections();
        }

        private void createNewConnection(Waiter waiter) {
            ++this.connCount;
            ContextImpl context = waiter.context == null ? ConnectionManager.this.vertx.getOrCreateContext() : waiter.context;
            ConnectionManager.this.sslHelper.validate(ConnectionManager.this.vertx);
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)context.nettyEventLoop());
            bootstrap.channel(ConnectionManager.this.vertx.transport().channelType(false));
            ConnectionManager.this.connector.connect(this, bootstrap, context, this.peerHost, this.ssl, this.pool.version(), this.host, this.port, waiter);
        }

        Waiter getNextWaiter() {
            Waiter waiter = this.waiters.poll();
            if (ConnectionManager.this.metrics != null && waiter != null) {
                ConnectionManager.this.metrics.dequeueRequest(this.metric, waiter.metric);
            }
            while (waiter != null && waiter.isCancelled()) {
                waiter = this.waiters.poll();
                if (ConnectionManager.this.metrics == null || waiter == null) continue;
                ConnectionManager.this.metrics.dequeueRequest(this.metric, waiter.metric);
            }
            return waiter;
        }

        public synchronized void connectionClosed() {
            --this.connCount;
            Waiter waiter = this.getNextWaiter();
            if (waiter != null) {
                this.createNewConnection(waiter);
            } else if (this.connCount == 0) {
                this.mgr.queueMap.remove(this.key);
                if (ConnectionManager.this.metrics != null) {
                    ConnectionManager.this.metrics.closeEndpoint(this.host, this.port, this.metric);
                }
            }
        }

        private void handshakeFailure(ContextImpl context, Channel ch, Throwable cause, Waiter waiter) {
            SSLHandshakeException sslException = new SSLHandshakeException("Failed to create SSL connection");
            if (cause != null) {
                sslException.initCause(cause);
            }
            this.connectionFailed(context, ch, waiter::handleFailure, sslException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fallbackToHttp1x(Channel ch, ContextImpl context, HttpVersion fallbackVersion, int port, String host, Waiter waiter) {
            ConnQueue connQueue = this;
            synchronized (connQueue) {
                this.pool = new Http1xPool(ConnectionManager.this.client, ConnectionManager.this.metrics, ConnectionManager.this.options, this, this.mgr.connectionMap, fallbackVersion, ConnectionManager.this.options.getMaxPoolSize(), host, port);
            }
            this.http1xConnected(fallbackVersion, context, port, host, ch, waiter);
        }

        private void http1xConnected(HttpVersion version, ContextImpl context, int port, String host, Channel ch, Waiter waiter) {
            ((Http1xPool)this.pool).createConn(context, ch, waiter);
        }

        private void http2Connected(ContextImpl context, Channel ch, Waiter waiter, boolean upgrade) {
            context.executeFromIO(() -> {
                try {
                    ((Http2Pool)this.pool).createConn(context, ch, waiter, upgrade);
                }
                catch (Http2Exception e) {
                    this.connectionFailed(context, ch, waiter::handleFailure, e);
                }
            });
        }

        private void connectionFailed(ContextImpl context, Channel ch, Handler<Throwable> connectionExceptionHandler, Throwable t) {
            Handler<Throwable> exHandler = connectionExceptionHandler == null ? log::error : connectionExceptionHandler;
            context.executeFromIO(() -> {
                this.connectionClosed();
                try {
                    ch.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                exHandler.handle(t);
            });
        }
    }

    private class QueueManager {
        private final Map<Channel, HttpClientConnection> connectionMap = new ConcurrentHashMap<Channel, HttpClientConnection>();
        private final Map<ConnectionKey, ConnQueue> queueMap = new ConcurrentHashMap<ConnectionKey, ConnQueue>();

        private QueueManager() {
        }

        ConnQueue getConnQueue(String peerHost, boolean ssl, int port, String host, HttpVersion version) {
            ConnectionKey key = new ConnectionKey(ssl, port, peerHost);
            return this.queueMap.computeIfAbsent(key, targetAddress -> new ConnQueue(version, this, peerHost, host, port, ssl, key));
        }

        public void close() {
            for (ConnQueue queue : this.queueMap.values()) {
                queue.closeAllConnections();
            }
            this.queueMap.clear();
            for (HttpClientConnection conn : this.connectionMap.values()) {
                conn.close();
            }
        }
    }

    static final class ConnectionKey {
        private final boolean ssl;
        private final int port;
        private final String host;

        public ConnectionKey(boolean ssl, int port, String host) {
            this.ssl = ssl;
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            if (this.ssl != that.ssl) {
                return false;
            }
            if (this.port != that.port) {
                return false;
            }
            return Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            int result = this.ssl ? 1 : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }
}

