/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;

class WorkerExecutorImpl
implements Closeable,
MetricsProvider,
WorkerExecutorInternal {
    private final Vertx vertx;
    private final WorkerPool pool;
    private boolean closed;
    private final boolean releaseOnClose;

    public WorkerExecutorImpl(Vertx vertx, WorkerPool pool, boolean releaseOnClose) {
        this.vertx = vertx;
        this.pool = pool;
        this.releaseOnClose = releaseOnClose;
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    public WorkerPool getPool() {
        return this.pool;
    }

    @Override
    public synchronized <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        if (this.closed) {
            throw new IllegalStateException("Worker executor closed");
        }
        ContextImpl context = (ContextImpl)this.vertx.getOrCreateContext();
        context.executeBlocking(null, blockingCodeHandler, asyncResultHandler, this.pool.executor(), ordered ? context.orderedTasks : null, this.pool.metrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.releaseOnClose && this.pool instanceof VertxImpl.SharedWorkerPool) {
            ((VertxImpl.SharedWorkerPool)this.pool).release();
        }
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.close();
        completionHandler.handle(Future.succeededFuture());
    }
}

