/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ProxyChannelProvider
extends ChannelProvider {
    public static final ChannelProvider INSTANCE = new ProxyChannelProvider();

    private ProxyChannelProvider() {
    }

    @Override
    public void connect(VertxInternal vertx, Bootstrap bootstrap, ProxyOptions options, SocketAddress remoteAddress, Handler<Channel> channelInitializer, Handler<AsyncResult<Channel>> channelHandler) {
        String proxyHost = options.getHost();
        int proxyPort = options.getPort();
        String proxyUsername = options.getUsername();
        String proxyPassword = options.getPassword();
        ProxyType proxyType = options.getType();
        vertx.resolveAddress(proxyHost, dnsRes -> {
            if (dnsRes.succeeded()) {
                HttpProxyHandler proxy;
                InetAddress address = (InetAddress)dnsRes.result();
                InetSocketAddress proxyAddr = new InetSocketAddress(address, proxyPort);
                switch (proxyType) {
                    default: {
                        proxy = proxyUsername != null && proxyPassword != null ? new HttpProxyHandler((java.net.SocketAddress)proxyAddr, proxyUsername, proxyPassword) : new HttpProxyHandler((java.net.SocketAddress)proxyAddr);
                        break;
                    }
                    case SOCKS5: {
                        proxy = proxyUsername != null && proxyPassword != null ? new Socks5ProxyHandler((java.net.SocketAddress)proxyAddr, proxyUsername, proxyPassword) : new Socks5ProxyHandler((java.net.SocketAddress)proxyAddr);
                        break;
                    }
                    case SOCKS4: {
                        proxy = proxyUsername != null ? new Socks4ProxyHandler((java.net.SocketAddress)proxyAddr, proxyUsername) : new Socks4ProxyHandler((java.net.SocketAddress)proxyAddr);
                    }
                }
                bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
                java.net.SocketAddress targetAddress = vertx.transport().convert(remoteAddress, false);
                bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>((ProxyHandler)proxy, channelInitializer, channelHandler){
                    final /* synthetic */ ProxyHandler val$proxy;
                    final /* synthetic */ Handler val$channelInitializer;
                    final /* synthetic */ Handler val$channelHandler;
                    {
                        this.val$proxy = proxyHandler;
                        this.val$channelInitializer = handler;
                        this.val$channelHandler = handler2;
                    }

                    protected void initChannel(final Channel ch) throws Exception {
                        final ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addFirst("proxy", (ChannelHandler)this.val$proxy);
                        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                if (evt instanceof ProxyConnectionEvent) {
                                    pipeline.remove((ChannelHandler)val$proxy);
                                    pipeline.remove((ChannelHandler)this);
                                    val$channelInitializer.handle(ch);
                                    val$channelHandler.handle(Future.succeededFuture(ch));
                                }
                                ctx.fireUserEventTriggered(evt);
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                val$channelHandler.handle(Future.failedFuture(cause));
                            }
                        }});
                    }
                });
                ChannelFuture future = bootstrap.connect(targetAddress);
                future.addListener(res -> {
                    if (!res.isSuccess()) {
                        channelHandler.handle(Future.failedFuture(res.cause()));
                    }
                });
            } else {
                channelHandler.handle(Future.failedFuture(dnsRes.cause()));
            }
        });
    }
}

