/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.List;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.runtime.connector.Connector;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.runtime.api.connector.ConnectorActionDefinitionFinder;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.connector.VariablesMatchHelper;
import org.springframework.context.ApplicationContext;

public class DefaultServiceTaskBehavior
extends AbstractBpmnActivityBehavior {
    private final ApplicationContext applicationContext;
    private final IntegrationContextBuilder integrationContextBuilder;
    private ConnectorActionDefinitionFinder connectorActionDefinitionFinder;
    private VariablesMatchHelper variablesMatchHelper;

    public DefaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, ConnectorActionDefinitionFinder connectorActionDefinitionFinder, VariablesMatchHelper variablesMatchHelper) {
        this.applicationContext = applicationContext;
        this.integrationContextBuilder = integrationContextBuilder;
        this.connectorActionDefinitionFinder = connectorActionDefinitionFinder;
        this.variablesMatchHelper = variablesMatchHelper;
    }

    public void execute(DelegateExecution execution) {
        Connector connector;
        IntegrationContext context;
        String implementation = ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
        List outBoundVariableDefinitions = null;
        if (this.connectorActionDefinitionFinder != null) {
            Optional<ActionDefinition> actionDefinitionOptional = this.connectorActionDefinitionFinder.find(implementation);
            ActionDefinition actionDefinition = null;
            if (actionDefinitionOptional.isPresent()) {
                actionDefinition = actionDefinitionOptional.get();
                context = this.integrationContextBuilder.from(execution, actionDefinition);
                connector = (Connector)this.applicationContext.getBean(actionDefinition.getName(), Connector.class);
            } else {
                context = this.integrationContextBuilder.from(execution, null);
                connector = (Connector)this.applicationContext.getBean(implementation, Connector.class);
            }
            outBoundVariableDefinitions = actionDefinition == null ? null : actionDefinition.getOutputs();
        } else {
            context = this.integrationContextBuilder.from(execution, null);
            connector = (Connector)this.applicationContext.getBean(implementation, Connector.class);
        }
        IntegrationContext results = (IntegrationContext)connector.apply((Object)context);
        if (this.variablesMatchHelper != null) {
            execution.setVariables(this.variablesMatchHelper.match(results.getOutBoundVariables(), outBoundVariableDefinitions));
        } else {
            execution.setVariables(results.getOutBoundVariables());
        }
        this.leave(execution);
    }

    private String getServiceTaskImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    protected boolean hasConnectorBean(DelegateExecution execution) {
        String implementation = this.getServiceTaskImplementation(execution);
        return this.applicationContext.containsBean(implementation) && this.applicationContext.getBean(implementation) instanceof Connector;
    }
}

