/*
 * Decompiled with CFR 0.152.
 */
package org.conf.activiti.runtime.api;

import java.io.IOException;
import java.util.List;
import org.activiti.core.common.model.connector.ConnectorDefinition;
import org.activiti.core.common.spring.connector.ConnectorDefinitionService;
import org.activiti.runtime.api.connector.ConnectorActionDefinitionFinder;
import org.activiti.runtime.api.connector.DefaultServiceTaskBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.connector.VariablesMatchHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConnectorsAutoConfiguration {
    @Autowired
    private ConnectorDefinitionService connectorDefinitionService;

    @Bean
    public List<ConnectorDefinition> connectorDefinitions() throws IOException {
        return this.connectorDefinitionService.get();
    }

    @Bean
    public IntegrationContextBuilder integrationContextBuilder(VariablesMatchHelper variablesMatchHelper) {
        return new IntegrationContextBuilder(variablesMatchHelper);
    }

    @Bean(name={"defaultServiceTaskBehavior"})
    @ConditionalOnMissingBean(name={"defaultServiceTaskBehavior"})
    public DefaultServiceTaskBehavior defaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, ConnectorActionDefinitionFinder connectorActionDefinitionFinder, VariablesMatchHelper variablesMatchHelper) throws IOException {
        return new DefaultServiceTaskBehavior(applicationContext, integrationContextBuilder, connectorActionDefinitionFinder, variablesMatchHelper);
    }

    @Bean
    public ConnectorActionDefinitionFinder connectorActionDefinitionFinder() throws IOException {
        return new ConnectorActionDefinitionFinder(this.connectorDefinitions());
    }

    @Bean
    public VariablesMatchHelper variablesMatchHelper() {
        return new VariablesMatchHelper();
    }
}

