/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.init;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HeartbeatSenderInitFunc
implements InitFunc {
    private static ScheduledExecutorService pool = Executors.newScheduledThreadPool(2, (ThreadFactory)new NamedThreadFactory("sentinel-heartbeat-send-task", true));

    public void init() throws Exception {
        long heartBeatInterval = -1L;
        try {
            heartBeatInterval = TransportConfig.getHeartbeatIntervalMs();
            RecordLog.info((String)("system property heartbeat interval set: " + heartBeatInterval), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            RecordLog.info((String)("Parse heartbeat interval failed, use that in code, " + ex.getMessage()), (Object[])new Object[0]);
        }
        ServiceLoader<HeartbeatSender> loader = ServiceLoader.load(HeartbeatSender.class);
        Iterator<HeartbeatSender> iterator = loader.iterator();
        if (iterator.hasNext()) {
            final HeartbeatSender sender = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("Only single heartbeat sender can be scheduled");
            }
            long interval = sender.intervalMs();
            if (heartBeatInterval != -1L) {
                interval = heartBeatInterval;
            }
            pool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        sender.sendHeartbeat();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RecordLog.info((String)"[HeartbeatSender] Send heartbeat error", (Throwable)e);
                    }
                }
            }, 10000L, interval, TimeUnit.MILLISECONDS);
            RecordLog.info((String)("[HeartbeatSenderInit] HeartbeatSender started: " + sender.getClass().getCanonicalName()), (Object[])new Object[0]);
        }
    }
}

