/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springmvc;

import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.io.IOException;
import java.util.Map;

public class SpringMvcDigestEncoder
extends AbstractDigestSpanEncoder {
    public String encode(SofaTracerSpan span) throws IOException {
        XStringBuilder xsb = new XStringBuilder();
        xsb.reset();
        xsb.append(Timestamp.format((long)span.getEndTime()));
        this.appendSlot(xsb, span);
        return xsb.toString();
    }

    private void appendSlot(XStringBuilder xsb, SofaTracerSpan sofaTracerSpan) {
        SofaTracerSpanContext context = sofaTracerSpan.getSofaTracerSpanContext();
        Map tagWithStr = sofaTracerSpan.getTagsWithStr();
        Map tagWithNumber = sofaTracerSpan.getTagsWithNumber();
        xsb.append((String)tagWithStr.get("local.app"));
        xsb.append(context.getTraceId());
        xsb.append(context.getSpanId());
        xsb.append((String)tagWithStr.get("request.url"));
        xsb.append((String)tagWithStr.get("method"));
        xsb.append((String)tagWithStr.get("result.code"));
        Number requestSize = (Number)tagWithNumber.get("req.size.bytes");
        xsb.append((requestSize == null ? 0L : requestSize.longValue()) + "B");
        Number responseSize = (Number)tagWithNumber.get("resp.size.bytes");
        xsb.append((responseSize == null ? 0L : responseSize.longValue()) + "B");
        xsb.append(sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime() + "ms");
        xsb.append((String)tagWithStr.get("current.thread.name"));
        xsb.appendEnd(this.baggageSerialized(context));
    }
}

