/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springmvc;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.io.IOException;
import java.util.Map;

public class SpringMvcDigestJsonEncoder
extends AbstractDigestSpanEncoder {
    public String encode(SofaTracerSpan span) throws IOException {
        JsonStringBuilder jsonStringBuilder = new JsonStringBuilder();
        jsonStringBuilder.appendBegin("time", (Object)Timestamp.format((long)span.getEndTime()));
        this.appendSlot(jsonStringBuilder, span);
        return jsonStringBuilder.toString();
    }

    private void appendSlot(JsonStringBuilder jsonStringBuilder, SofaTracerSpan sofaTracerSpan) {
        SofaTracerSpanContext context = sofaTracerSpan.getSofaTracerSpanContext();
        Map tagWithStr = sofaTracerSpan.getTagsWithStr();
        Map tagWithNumber = sofaTracerSpan.getTagsWithNumber();
        jsonStringBuilder.append("local.app", tagWithStr.get("local.app"));
        jsonStringBuilder.append("traceId", (Object)context.getTraceId());
        jsonStringBuilder.append("spanId", (Object)context.getSpanId());
        jsonStringBuilder.append("request.url", tagWithStr.get("request.url"));
        jsonStringBuilder.append("method", tagWithStr.get("method"));
        jsonStringBuilder.append("result.code", tagWithStr.get("result.code"));
        Number requestSize = (Number)tagWithNumber.get("req.size.bytes");
        jsonStringBuilder.append("req.size.bytes", (Object)(requestSize == null ? 0L : requestSize.longValue()));
        Number responseSize = (Number)tagWithNumber.get("resp.size.bytes");
        jsonStringBuilder.append("resp.size.bytes", (Object)(responseSize == null ? 0L : responseSize.longValue()));
        jsonStringBuilder.append("time.cost.milliseconds", (Object)(sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime()));
        jsonStringBuilder.append("current.thread.name", tagWithStr.get("current.thread.name"));
        jsonStringBuilder.appendEnd("baggage", (Object)this.baggageSerialized(context));
    }
}

