/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springmvc;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcHeadersCarrier;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcTracer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SpringMvcSofaTracerFilter
implements Filter {
    private String appName = "";
    private SpringMvcTracer springMvcTracer;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.springMvcTracer == null) {
            this.springMvcTracer = SpringMvcTracer.getSpringMvcTracerSingleton();
        }
        SofaTracerSpan springMvcSpan = null;
        long responseSize = -1L;
        int httpStatus = -1;
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            SofaTracerSpanContext spanContext = this.getSpanContextFromRequest(request);
            springMvcSpan = this.springMvcTracer.serverReceive(spanContext);
            if (StringUtils.isBlank((String)this.appName)) {
                this.appName = SofaTracerConfiguration.getProperty((String)"spring.application.name");
            }
            springMvcSpan.setOperationName(request.getRequestURL().toString());
            springMvcSpan.setTag("local.app", this.appName);
            springMvcSpan.setTag("request.url", request.getRequestURL().toString());
            springMvcSpan.setTag("method", request.getMethod());
            springMvcSpan.setTag("req.size.bytes", (Number)request.getContentLength());
            ResponseWrapper responseWrapper = new ResponseWrapper(response);
            filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
            httpStatus = responseWrapper.getStatus();
            responseSize = responseWrapper.getContentLength();
        }
        catch (Exception e) {
            SelfLog.error((String)"Spring MVC Tracer error occurs in SpringMvcSofaTracerFilter.doFilter.", (Throwable)e);
        }
        finally {
            if (springMvcSpan != null) {
                springMvcSpan.setTag("resp.size.bytes", (Number)responseSize);
                this.springMvcTracer.serverSend(String.valueOf(httpStatus));
            }
        }
    }

    public void destroy() {
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getFilterName() {
        return "SpringMvcSofaTracerFilter";
    }

    public SofaTracerSpanContext getSpanContextFromRequest(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            headers.put(key, value);
        }
        SofaTracer tracer = this.springMvcTracer.getSofaTracer();
        SofaTracerSpanContext spanContext = (SofaTracerSpanContext)tracer.extract(ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new SpringMvcHeadersCarrier(headers));
        return spanContext;
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        int contentLength;

        public ResponseWrapper(HttpServletResponse httpServletResponse) throws IOException {
            super(httpServletResponse);
            this.contentLength = 0;
        }

        public void setContentLength(int len) {
            this.contentLength = len;
            super.setContentLength(len);
        }

        public int getContentLength() {
            return this.contentLength;
        }
    }
}

