package com.dahuatech.icc.oauth.model.v202010;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.constant.OauthConstant;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 校验token，无需鉴权
 *
 * @author 232676
 * @since 1.0.0 2020-10-24 20:59:11
 */
public class OauthCheckTokenRequest extends AbstractIccRequest<OauthCheckTokenResponse> {

  private String token;

  public OauthCheckTokenRequest() throws ClientException {
    super(OauthConstant.url(OauthConstant.OAUTH_URL_CHECK_TOKEN_POST), Method.POST, Boolean.FALSE);
  }

  @Override
  public Class<OauthCheckTokenResponse> getResponseClass() {
    return OauthCheckTokenResponse.class;
  }

  public String getToken() {
    return token;
  }

  public void setToken(String token) {
    this.token = token;
    httpRequest.form("token", token);
  }
}
