/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.http;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public abstract class AbstractHttpDelegate {
    static final String OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
    static final String VERSION = System.getProperty("java.version");

    public String get(String url) {
        return HttpUtil.get((String)url);
    }

    public Map<String, Object> get(String url, String authorization, String serialNumber, Map<String, Object> paramMap) {
        HttpResponse httpResponse = this.getToResponse(url, authorization, serialNumber, paramMap);
        return this.buildResMap(httpResponse);
    }

    private HttpResponse getToResponse(String url, String authorization, String serialNumber, Map<String, Object> paramMap) {
        return ((HttpRequest)HttpRequest.get((String)url).addHeaders(this.getHeaders(authorization, serialNumber))).form(paramMap).execute();
    }

    public String get(String url, Map<String, Object> paramMap) {
        return HttpUtil.get((String)url, paramMap);
    }

    public String post(String url, String data) {
        return HttpUtil.post((String)url, (String)data);
    }

    public String post(String url, Map<String, Object> paramMap) {
        return HttpUtil.post((String)url, paramMap);
    }

    public Map<String, Object> postBySafe(String url, String authorization, String serialNumber, String jsonData) {
        HttpResponse httpResponse = this.postBySafeToResponse(url, authorization, serialNumber, jsonData);
        return this.buildResMap(httpResponse);
    }

    private HttpResponse postBySafeToResponse(String url, String authorization, String serialNumber, String jsonData) {
        return ((HttpRequest)HttpRequest.post((String)url).addHeaders(this.getHeaders(authorization, serialNumber))).body(jsonData).execute();
    }

    public Map<String, Object> delete(String url, String authorization, String serialNumber, String jsonData) {
        HttpResponse httpResponse = this.deleteToResponse(url, authorization, serialNumber, jsonData);
        return this.buildResMap(httpResponse);
    }

    private HttpResponse deleteToResponse(String url, String authorization, String serialNumber, String jsonData) {
        return ((HttpRequest)HttpRequest.delete((String)url).addHeaders(this.getHeaders(authorization, serialNumber))).body(jsonData).execute();
    }

    public Map<String, Object> upload(String url, String authorization, String serialNumber, String jsonData, File file) {
        HttpResponse httpResponse = this.uploadToResponse(url, authorization, serialNumber, jsonData, file);
        return this.buildResMap(httpResponse);
    }

    private HttpResponse uploadToResponse(String url, String authorization, String serialNumber, String jsonData, File file) {
        return ((HttpRequest)HttpRequest.post((String)url).addHeaders(this.getUploadHeaders(authorization, serialNumber))).form("file", file).form("meta", (Object)jsonData).execute();
    }

    private Map<String, Object> buildResMap(HttpResponse httpResponse) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String timestamp = httpResponse.header("Wechatpay-Timestamp");
        String nonceStr = httpResponse.header("Wechatpay-Nonce");
        String serialNo = httpResponse.header("Wechatpay-Serial");
        String signature = httpResponse.header("Wechatpay-Signature");
        String body = httpResponse.body();
        int status = httpResponse.getStatus();
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("serialNumber", serialNo);
        map.put("signature", signature);
        map.put("body", body);
        map.put("status", status);
        return map;
    }

    public String upload(String url, String data, String certPath, String certPass, String filePath) {
        try {
            File file = FileUtil.newFile((String)filePath);
            return ((HttpRequest)HttpRequest.post((String)url).setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol("TLSv1").setKeyManagers(this.getKeyManager(certPass, certPath, null)).setSecureRandom(new SecureRandom()).build()).header("Content-Type", "multipart/form-data;boundary=\"boundary\"")).form("file", file).form("meta", (Object)data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String post(String url, String data, String certPath, String certPass) {
        try {
            return HttpRequest.post((String)url).setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol("TLSv1").setKeyManagers(this.getKeyManager(certPass, certPath, null)).setSecureRandom(new SecureRandom()).build()).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String post(String url, String data, InputStream certFile, String certPass) {
        try {
            return HttpRequest.post((String)url).setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol("TLSv1").setKeyManagers(this.getKeyManager(certPass, null, certFile)).setSecureRandom(new SecureRandom()).build()).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyManager[] getKeyManager(String certPass, String certPath, InputStream certFile) throws Exception {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        if (certFile != null) {
            clientStore.load(certFile, certPass.toCharArray());
        } else {
            clientStore.load(new FileInputStream(certPath), certPass.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, certPass.toCharArray());
        return kmf.getKeyManagers();
    }

    private Map<String, String> getBaseHeaders(String authorization) {
        String userAgent = String.format("WeChatPay-IJPay-HttpClient/%s (%s) Java/%s", this.getClass().getPackage().getImplementationVersion(), OS, VERSION == null ? "Unknown" : VERSION);
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Accept", ContentType.JSON.toString());
        headers.put("Authorization", authorization);
        headers.put("User-Agent", userAgent);
        return headers;
    }

    private Map<String, String> getHeaders(String authorization, String serialNumber) {
        Map<String, String> headers = this.getBaseHeaders(authorization);
        headers.put("Content-Type", ContentType.JSON.toString());
        if (StrUtil.isNotEmpty((CharSequence)serialNumber)) {
            headers.put("Wechatpay-Serial", serialNumber);
        }
        return headers;
    }

    private Map<String, String> getUploadHeaders(String authorization, String serialNumber) {
        Map<String, String> headers = this.getBaseHeaders(authorization);
        headers.put("Content-Type", "multipart/form-data;boundary=\"boundary\"");
        if (StrUtil.isNotEmpty((CharSequence)serialNumber)) {
            headers.put("Wechatpay-Serial", serialNumber);
        }
        return headers;
    }
}

