/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.kit;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.ijpay.core.enums.RequestMethod;
import com.ijpay.core.enums.SignType;
import com.ijpay.core.kit.PayKit;
import com.ijpay.core.kit.RsaKit;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class WxPayKit {
    private static final String FIELD_SIGN = "sign";
    private static final String FIELD_SIGN_TYPE = "sign_type";

    public static String hmacSha256(String data, String key) {
        return PayKit.hmacSha256(data, key);
    }

    public static String md5(String data) {
        return PayKit.md5(data);
    }

    public static String decryptData(String base64Data, String key) {
        return PayKit.decryptData(base64Data, key);
    }

    public static String encryptData(String data, String key) {
        return PayKit.encryptData(data, key);
    }

    public static String generateStr() {
        return PayKit.generateStr();
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey) {
        String sign = params.get(FIELD_SIGN);
        String localSign = WxPayKit.createSign(params, partnerKey, SignType.MD5);
        return sign.equals(localSign);
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey, SignType signType) {
        String sign = params.get(FIELD_SIGN);
        String localSign = WxPayKit.createSign(params, partnerKey, signType);
        return sign.equals(localSign);
    }

    public static String createSign(Map<String, String> params, String partnerKey, SignType signType) {
        if (signType == null) {
            signType = SignType.MD5;
        }
        params.remove(FIELD_SIGN);
        String tempStr = PayKit.createLinkString(params);
        String stringSignTemp = tempStr + "&key=" + partnerKey;
        if (signType == SignType.MD5) {
            return WxPayKit.md5(stringSignTemp).toUpperCase();
        }
        return WxPayKit.hmacSha256(stringSignTemp, partnerKey).toUpperCase();
    }

    public static String createSign(Map<String, String> params, String secret) {
        params.remove(FIELD_SIGN);
        String tempStr = PayKit.createLinkString(params);
        String stringSignTemp = tempStr + "&secret=" + secret;
        return WxPayKit.md5(stringSignTemp).toUpperCase();
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, SignType signType) {
        return WxPayKit.buildSign(params, partnerKey, signType, true);
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, SignType signType, boolean haveSignType) {
        if (haveSignType) {
            params.put(FIELD_SIGN_TYPE, signType.getType());
        }
        String sign = WxPayKit.createSign(params, partnerKey, signType);
        params.put(FIELD_SIGN, sign);
        return params;
    }

    public static StringBuffer forEachMap(Map<String, String> params, String prefix, String suffix) {
        return PayKit.forEachMap(params, prefix, suffix);
    }

    public static String toXml(Map<String, String> params) {
        return PayKit.toXml(params);
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        return PayKit.xmlToMap(xmlStr);
    }

    public static String bizPayUrl(String sign, String appId, String mchId, String productId, String timeStamp, String nonceStr) {
        String rules = "weixin://wxpay/bizpayurl?sign=Temp&appid=Temp&mch_id=Temp&product_id=Temp&time_stamp=Temp&nonce_str=Temp";
        return WxPayKit.replace(rules, "Temp", sign, appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId, String timeStamp, String nonceStr, SignType signType) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", StrUtil.isEmpty((CharSequence)timeStamp) ? Long.toString(System.currentTimeMillis() / 1000L) : timeStamp);
        map.put("nonce_str", StrUtil.isEmpty((CharSequence)nonceStr) ? WxPayKit.generateStr() : nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, signType), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId) {
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = WxPayKit.generateStr();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", timeStamp);
        map.put("nonce_str", nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, null), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String replace(String str, String regex, String ... args) {
        for (String arg : args) {
            str = str.replaceFirst(regex, arg);
        }
        return str;
    }

    public static boolean codeIsOk(String codeValue) {
        return StrUtil.isNotEmpty((CharSequence)codeValue) && "SUCCESS".equals(codeValue);
    }

    public static Map<String, String> prepayIdCreateSign(String prepayId, String appId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (signType == null) {
            signType = SignType.MD5;
        }
        packageParams.put("signType", signType.getType());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static Map<String, String> appPrepayIdCreateSign(String appId, String partnerId, String prepayId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(8);
        packageParams.put("appid", appId);
        packageParams.put("partnerid", partnerId);
        packageParams.put("prepayid", prepayId);
        packageParams.put("package", "Sign=WXPay");
        packageParams.put("noncestr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        if (signType == null) {
            signType = SignType.MD5;
        }
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put(FIELD_SIGN, packageSign);
        return packageParams;
    }

    public static Map<String, String> miniAppPrepayIdCreateSign(String appId, String prepayId, String partnerKey, SignType signType) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (signType == null) {
            signType = SignType.MD5;
        }
        packageParams.put("signType", signType.getType());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, signType);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static String buildAuthorization(RequestMethod method, String urlSuffix, String mchId, String serialNo, String keyPath, String body, String nonceStr, long timestamp, String authType) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(method, urlSuffix, timestamp, nonceStr, body);
        PrivateKey privateKey = PayKit.getPrivateKey(keyPath);
        String signature = RsaKit.encryptByPrivateKey(buildSignMessage, privateKey);
        return PayKit.getAuthorization(mchId, serialNo, nonceStr, String.valueOf(timestamp), signature, authType);
    }

    public static String buildAuthorization(RequestMethod method, String urlSuffix, String mchId, String serialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = PayKit.generateStr();
        return WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, keyPath, body, nonceStr, timestamp, authType);
    }

    public static boolean verifySignature(Map<String, Object> map, String certPath) throws Exception {
        String signature = (String)map.get("signature");
        String body = (String)map.get("body");
        String nonceStr = (String)map.get("nonceStr");
        String timestamp = (String)map.get("timestamp");
        return WxPayKit.verifySignature(signature, body, nonceStr, timestamp, FileUtil.getInputStream((String)certPath));
    }

    public static boolean verifySignature(Map<String, Object> map, InputStream certInputStream) throws Exception {
        String signature = (String)map.get("signature");
        String body = (String)map.get("body");
        String nonceStr = (String)map.get("nonceStr");
        String timestamp = (String)map.get("timestamp");
        return WxPayKit.verifySignature(signature, body, nonceStr, timestamp, certInputStream);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, String publicKey) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, PublicKey publicKey) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, InputStream certInputStream) throws Exception {
        String buildSignMessage = PayKit.buildSignMessage(timestamp, nonce, body);
        X509Certificate certificate = PayKit.getCertificate(certInputStream);
        PublicKey publicKey = certificate.getPublicKey();
        return RsaKit.checkByPublicKey(buildSignMessage, signature, publicKey);
    }
}

