/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.wxpay;

import cn.hutool.core.util.StrUtil;
import com.ijpay.core.enums.PayModel;
import com.ijpay.core.enums.RequestMethod;
import com.ijpay.core.enums.SignType;
import com.ijpay.core.kit.HttpKit;
import com.ijpay.core.kit.PayKit;
import com.ijpay.core.kit.WxPayKit;
import com.ijpay.wxpay.enums.WxApiType;
import com.ijpay.wxpay.enums.WxDomain;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class WxPayApi {
    private WxPayApi() {
    }

    public static String getReqUrl(WxApiType wxApiType) {
        return WxPayApi.getReqUrl(wxApiType, null, false);
    }

    public static String getReqUrl(WxApiType wxApiType, boolean isSandBox) {
        return WxPayApi.getReqUrl(wxApiType, null, isSandBox);
    }

    public static String getReqUrl(WxApiType wxApiType, WxDomain wxDomain, boolean isSandBox) {
        if (wxDomain == null) {
            wxDomain = WxDomain.CHINA;
        }
        return wxDomain.getType().concat(isSandBox ? WxApiType.SAND_BOX_NEW.getType() : "").concat(wxApiType.getType());
    }

    public static String execution(String apiUrl, Map<String, String> params) {
        return WxPayApi.doPost(apiUrl, params);
    }

    public static String executionByGet(String apiUrl, Map<String, Object> params) {
        return WxPayApi.doGet(apiUrl, params);
    }

    public static String execution(String apiUrl, Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.doPostSSL(apiUrl, params, certPath, certPass);
    }

    public static String execution(String apiUrl, Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.doPostSSL(apiUrl, params, certFile, certPass);
    }

    public static String execution(String apiUrl, Map<String, String> params, String certPath, String certPass, String filePath) {
        return WxPayApi.doUploadSSL(apiUrl, params, certPath, certPass, filePath);
    }

    public static Map<String, Object> v3Execution(RequestMethod method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, String nonceStr, long timestamp, String authType, File file) throws Exception {
        String authorization = WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, keyPath, body, nonceStr, timestamp, authType);
        if (StrUtil.isEmpty((CharSequence)platSerialNo)) {
            platSerialNo = serialNo;
        }
        if (method == RequestMethod.GET) {
            return WxPayApi.doGet(urlPrefix.concat(urlSuffix), authorization, platSerialNo, null);
        }
        if (method == RequestMethod.POST) {
            return WxPayApi.doPost(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if (method == RequestMethod.DELETE) {
            return WxPayApi.doDelete(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if (method == RequestMethod.UPLOAD) {
            return WxPayApi.doUpload(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body, file);
        }
        return null;
    }

    public static Map<String, Object> v3Execution(RequestMethod method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        return WxPayApi.v3Execution(method, urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, body, nonceStr, timestamp, authType, null);
    }

    public static Map<String, Object> v3Execution(RequestMethod method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        return WxPayApi.v3Execution(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, nonceStr, timestamp, authType, null);
    }

    public static Map<String, Object> v3Execution(RequestMethod method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, Map<String, String> params) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        if (null != params && !params.keySet().isEmpty()) {
            urlSuffix = urlSuffix.concat("?").concat(PayKit.createLinkString(params, true));
        }
        System.out.println(urlSuffix);
        return WxPayApi.v3Execution(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, "", nonceStr, timestamp, authType, null);
    }

    public static Map<String, Object> v3Execution(RequestMethod method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, Map<String, String> params) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        if (null != params && !params.keySet().isEmpty()) {
            urlSuffix = urlSuffix.concat("?").concat(PayKit.createLinkString(params, true));
        }
        System.out.println(urlSuffix);
        return WxPayApi.v3Execution(method, urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, "", nonceStr, timestamp, authType, null);
    }

    public static Map<String, Object> v3Upload(String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, File file) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        return WxPayApi.v3Execution(RequestMethod.UPLOAD, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, nonceStr, timestamp, authType, file);
    }

    public static Map<String, Object> v3Upload(String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, String body, File file) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateStr();
        return WxPayApi.v3Execution(RequestMethod.UPLOAD, urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, body, nonceStr, timestamp, authType, file);
    }

    public static String getSignKey(String mch_id, String partnerKey, SignType signType) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        String nonce_str = WxPayKit.generateStr();
        map.put("mch_id", mch_id);
        map.put("nonce_str", nonce_str);
        map.put("sign", WxPayKit.createSign(map, partnerKey, signType));
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_SIGN_KEY), map);
    }

    public static String pushOrder(Map<String, String> params) {
        return WxPayApi.pushOrder(false, null, params);
    }

    public static String pushOrder(boolean isSandbox, Map<String, String> params) {
        return WxPayApi.pushOrder(isSandbox, null, params);
    }

    public static String pushOrder(boolean isSandbox, WxDomain wxDomain, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.UNIFIED_ORDER, wxDomain, isSandbox), params);
    }

    public static String orderQuery(Map<String, String> params) {
        return WxPayApi.orderQuery(false, null, params);
    }

    public static String orderQuery(boolean isSandbox, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.ORDER_QUERY, null, isSandbox), params);
    }

    public static String orderQuery(boolean isSandbox, WxDomain wxDomain, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.ORDER_QUERY, wxDomain, isSandbox), params);
    }

    public static String closeOrder(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.CLOSE_ORDER), params);
    }

    public static String orderReverse(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REVERSE), params, certPath, certPass);
    }

    public static String orderReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REVERSE), params, certFile, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REFUND, null, isSandbox), params, certPath, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REFUND, null, isSandbox), params, certFile, certPass);
    }

    public static String orderRefundQuery(boolean isSandbox, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REFUND_QUERY, null, isSandbox), params);
    }

    public static String downloadBill(boolean isSandbox, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DOWNLOAD_BILL, null, isSandbox), params);
    }

    public static String orderReport(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.REPORT, null, false), params);
    }

    public static String toShortUrl(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SHORT_URL, null, false), params);
    }

    public static String authCodeToOpenid(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.AUTH_CODE_TO_OPENID, null, false), params);
    }

    public static String microPay(boolean isSandbox, Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.MICRO_PAY, null, isSandbox), params);
    }

    public static String transfers(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.TRANSFER, null, false), params, certPath, certPass);
    }

    public static String transfers(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.TRANSFER, null, false), params, certFile, certPass);
    }

    public static String getTransferInfo(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_TRANSFER_INFO, null, false), params, certPath, certPass);
    }

    public static String getTransferInfo(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_TRANSFER_INFO, null, false), params, certFile, certPass);
    }

    public static String payBank(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.TRANSFER_BANK, null, false), params, certPath, certPass);
    }

    public static String payBank(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.TRANSFER_BANK, null, false), params, certFile, certPass);
    }

    public static String queryBank(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_TRANSFER_BANK_INFO, null, false), params, certPath, certPass);
    }

    public static String queryBank(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_TRANSFER_BANK_INFO, null, false), params, certFile, certPass);
    }

    public static String getPublicKey(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_PUBLIC_KEY, null, false), params, certPath, certPass);
    }

    public static String getPublicKey(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_PUBLIC_KEY, null, false), params, certFile, certPass);
    }

    public static String entrustWeb(Map<String, Object> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.ENTRUST_WEB), params);
        }
        return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.PARTNER_ENTRUST_WEB), params);
    }

    public static String preEntrustWeb(Map<String, Object> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.PRE_ENTRUST_WEB), params);
        }
        return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.PARTNER_PRE_ENTRUST_WEB), params);
    }

    public static String h5EntrustWeb(Map<String, Object> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.H5_ENTRUST_WEB), params);
        }
        return WxPayApi.executionByGet(WxPayApi.getReqUrl(WxApiType.PARTNER_H5_ENTRUST_WEB), params);
    }

    public static String contractOrder(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PAY_CONTRACT_ORDER), params);
    }

    public static String queryContract(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_ENTRUST_CONTRACT), params);
        }
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PARTNER_QUERY_ENTRUST_CONTRACT), params);
    }

    public static String papPayApply(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PAP_PAY_APPLY), params);
        }
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PARTNER_PAP_PAY_APPLY), params);
    }

    public static String deleteContract(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DELETE_ENTRUST_CONTRACT), params);
        }
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PARTNER_DELETE_ENTRUST_CONTRACT), params);
    }

    public static String contractBill(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_ENTRUST_CONTRACT), params);
        }
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PARTNER_QUERY_ENTRUST_CONTRACT), params);
    }

    public static String papOrderQuery(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PAP_ORDER_QUERY), params);
        }
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PARTNER_PAP_ORDER_QUERY), params);
    }

    public static String profitSharing(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING), params, certPath, certPass);
    }

    public static String profitSharing(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING), params, certFile, certPass);
    }

    public static String multiProfitSharing(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.MULTI_PROFIT_SHARING), params, certPath, certPass);
    }

    public static String multiProfitSharing(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.MULTI_PROFIT_SHARING), params, certFile, certPass);
    }

    public static String profitSharingQuery(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_QUERY), params);
    }

    public static String profitSharingAddReceiver(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFITS_HARING_ADD_RECEIVER), params);
    }

    public static String profitSharingRemoveReceiver(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_REMOVE_RECEIVER), params);
    }

    public static String profitSharingFinish(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_FINISH), params, certPath, certPass);
    }

    public static String profitSharingFinish(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_FINISH), params, certFile, certPass);
    }

    public static String profitSharingReturn(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_RETURN), params, certPath, certPass);
    }

    public static String profitSharingReturn(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_RETURN), params, certFile, certPass);
    }

    public static String profitSharingReturnQuery(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PROFIT_SHARING_RETURN_QUERY), params);
    }

    public static String sendCoupon(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_COUPON), params, certPath, certPass);
    }

    public static String sendCoupon(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_COUPON), params, certFile, certPass);
    }

    public static String queryCouponStock(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_COUPON_STOCK), params);
    }

    public static String queryCouponsInfo(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_COUPONS_INFO), params);
    }

    public static String batchQueryComment(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.BATCH_QUERY_COMMENT), params, certPath, certPass);
    }

    public static String batchQueryComment(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.BATCH_QUERY_COMMENT), params, certFile, certPass);
    }

    public static String depositFacePay(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_FACE_PAY), params);
    }

    public static String depositMicroPay(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_MICRO_PAY), params);
    }

    public static String depositOrderQuery(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_ORDER_QUERY), params);
    }

    public static String depositReverse(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_REVERSE), params, certPath, certPass);
    }

    public static String depositReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_REVERSE), params, certFile, certPass);
    }

    public static String depositConsume(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_CONSUME), params, certPath, certPass);
    }

    public static String depositConsume(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_CONSUME), params, certFile, certPass);
    }

    public static String depositRefund(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_REFUND), params, certPath, certPass);
    }

    public static String depositRefund(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_REFUND), params, certFile, certPass);
    }

    public static String depositRefundQuery(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DEPOSIT_REFUND_QUERY), params);
    }

    public static String downloadFundFlow(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DOWNLOAD_FUND_FLOW), params, certPath, certPass);
    }

    public static String downloadFundFlow(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.DOWNLOAD_FUND_FLOW), params, certFile, certPass);
    }

    public static String facePay(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.FACE_PAY), params);
    }

    public static String facePayQuery(Map<String, String> params) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.FACE_PAY_QUERY), params);
    }

    public static String facePayReverse(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.FACE_PAY_REVERSE), params, certPath, certPass);
    }

    public static String facePayReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.FACE_PAY_REVERSE), params, certFile, certPass);
    }

    public static String sendRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_RED_PACK), params, certPath, certPass);
    }

    public static String sendRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_RED_PACK), params, certFile, certPass);
    }

    public static String sendGroupRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_GROUP_RED_PACK), params, certPath, certPass);
    }

    public static String sendGroupRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_GROUP_RED_PACK), params, certFile, certPass);
    }

    public static String getHbInfo(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_HB_INFO), params, certPath, certPass);
    }

    public static String getHbInfo(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.GET_HB_INFO), params, certFile, certPass);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_MINI_PROGRAM_HB), params, certPath, certPass);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_MINI_PROGRAM_HB), params, certFile, certPass);
    }

    public static String sendWorkWxRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_WORK_WX_RED_PACK), params, certPath, certPass);
    }

    public static String sendWorkWxRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.SEND_WORK_WX_RED_PACK), params, certFile, certPass);
    }

    public static String queryWorkWxRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_WORK_WX_RED_PACK), params, certPath, certPass);
    }

    public static String queryWorkWxRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_WORK_WX_RED_PACK), params, certFile, certPass);
    }

    public static String trans2pocket(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PAY_WWS_TRANS_2_POCKET), params, certPath, certPass);
    }

    public static String trans2pocket(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.PAY_WWS_TRANS_2_POCKET), params, certFile, certPass);
    }

    public static String queryTrans2pocket(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_WWS_TRANS_2_POCKET), params, certPath, certPass);
    }

    public static String queryTrans2pocket(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.execution(WxPayApi.getReqUrl(WxApiType.QUERY_WWS_TRANS_2_POCKET), params, certFile, certPass);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return HttpKit.getDelegate().get(url, params);
    }

    public static Map<String, Object> doGet(String url, String authorization, String serialNumber, Map<String, Object> params) {
        return HttpKit.getDelegate().get(url, authorization, serialNumber, params);
    }

    public static Map<String, Object> doPost(String url, String authorization, String serialNumber, String data) {
        return HttpKit.getDelegate().postBySafe(url, authorization, serialNumber, data);
    }

    public static Map<String, Object> doDelete(String url, String authorization, String serialNumber, String data) {
        return HttpKit.getDelegate().delete(url, authorization, serialNumber, data);
    }

    public static Map<String, Object> doUpload(String url, String authorization, String serialNumber, String data, File file) {
        return HttpKit.getDelegate().upload(url, authorization, serialNumber, data, file);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params));
    }

    public static String doPostSSL(String url, Map<String, String> params, String certPath, String certPass) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params), certPath, certPass);
    }

    public static String doUploadSSL(String url, Map<String, String> params, String certPath, String certPass, String filePath) {
        return HttpKit.getDelegate().upload(url, WxPayKit.toXml(params), certPath, certPass, filePath);
    }

    public static String doPostSSL(String url, Map<String, String> params, InputStream certFile, String certPass) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params), certFile, certPass);
    }
}

