/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.other;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class CharType {
    public static final byte CT_SINGLE = 5;
    public static final byte CT_DELIMITER = 6;
    public static final byte CT_CHINESE = 7;
    public static final byte CT_LETTER = 8;
    public static final byte CT_NUM = 9;
    public static final byte CT_INDEX = 10;
    public static final byte CT_CNUM = 11;
    public static final byte CT_OTHER = 17;
    public static byte[] type = new byte[65536];

    private static ByteArray generate() throws IOException {
        int preType = 5;
        int preChar = 0;
        LinkedList<int[]> typeList = new LinkedList<int[]>();
        for (int i = 0; i <= 65535; ++i) {
            int type = TextUtility.charType((char)i);
            if (type != preType) {
                int[] array2 = new int[]{preChar, i - 1, preType};
                typeList.add(array2);
                preChar = i;
            }
            preType = type;
        }
        int[] array = new int[]{preChar, 65535, preType};
        typeList.add(array);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(HanLP.Config.CharTypePath));
        for (int[] array2 : typeList) {
            out.writeChar(array2[0]);
            out.writeChar(array2[1]);
            out.writeByte(array2[2]);
        }
        out.close();
        ByteArray byteArray = ByteArray.createByteArray(HanLP.Config.CharTypePath);
        return byteArray;
    }

    public static byte get(char c) {
        return type[c];
    }

    static {
        Predefine.logger.info("\u5b57\u7b26\u7c7b\u578b\u5bf9\u5e94\u8868\u5f00\u59cb\u52a0\u8f7d " + HanLP.Config.CharTypePath);
        long start = System.currentTimeMillis();
        ByteArray byteArray = ByteArray.createByteArray(HanLP.Config.CharTypePath);
        if (byteArray == null) {
            try {
                byteArray = CharType.generate();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("\u5b57\u7b26\u7c7b\u578b\u5bf9\u5e94\u8868 " + HanLP.Config.CharTypePath + " \u52a0\u8f7d\u5931\u8d25\uff1a " + TextUtility.exceptionToString(e));
            }
        }
        while (byteArray.hasMore()) {
            int b = byteArray.nextChar();
            char e = byteArray.nextChar();
            byte t = byteArray.nextByte();
            for (int i = b; i <= e; ++i) {
                CharType.type[i] = t;
            }
        }
        Predefine.logger.info("\u5b57\u7b26\u7c7b\u578b\u5bf9\u5e94\u8868\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + " ms");
    }
}

