/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import java.util.Arrays;

public class Vector {
    float[] elementArray;

    public Vector(float[] elementArray) {
        this.elementArray = elementArray;
    }

    public Vector(int size) {
        this.elementArray = new float[size];
        Arrays.fill(this.elementArray, 0.0f);
    }

    public int size() {
        return this.elementArray.length;
    }

    public float dot(Vector other) {
        float ret = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            ret += this.elementArray[i] * other.elementArray[i];
        }
        return ret;
    }

    public float norm() {
        float ret = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            ret += this.elementArray[i] * this.elementArray[i];
        }
        return (float)Math.sqrt(ret);
    }

    public float cosineForUnitVector(Vector other) {
        return this.dot(other);
    }

    public float cosine(Vector other) {
        return this.dot(other) / this.norm() / other.norm();
    }

    public Vector minus(Vector other) {
        float[] result = new float[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.elementArray[i] - other.elementArray[i];
        }
        return new Vector(result);
    }

    public Vector add(Vector other) {
        float[] result = new float[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.elementArray[i] + other.elementArray[i];
        }
        return new Vector(result);
    }

    public Vector addToSelf(Vector other) {
        for (int i = 0; i < this.elementArray.length; ++i) {
            this.elementArray[i] = this.elementArray[i] + other.elementArray[i];
        }
        return this;
    }

    public Vector divideToSelf(int n) {
        for (int i = 0; i < this.elementArray.length; ++i) {
            this.elementArray[i] = this.elementArray[i] / (float)n;
        }
        return this;
    }

    public Vector divideToSelf(float f) {
        for (int i = 0; i < this.elementArray.length; ++i) {
            this.elementArray[i] = this.elementArray[i] / f;
        }
        return this;
    }

    public Vector normalize() {
        this.divideToSelf(this.norm());
        return this;
    }
}

