/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.crf.CRFTagger;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import com.hankcs.hanlp.tokenizer.lexical.POSTagger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CRFPOSTagger
extends CRFTagger
implements POSTagger {
    public CRFPOSTagger() throws IOException {
        this(HanLP.Config.CRFPOSModelPath);
    }

    public CRFPOSTagger(String modelPath) throws IOException {
        super(modelPath);
    }

    @Override
    protected void convertCorpus(Sentence sentence, BufferedWriter bw) throws IOException {
        List<Word> simpleWordList = sentence.toSimpleWordList();
        ArrayList<String> wordList = new ArrayList<String>(simpleWordList.size());
        for (Word word : simpleWordList) {
            wordList.add(word.value);
        }
        String[] words = wordList.toArray(new String[0]);
        Iterator<Word> iterator = simpleWordList.iterator();
        for (int i = 0; i < words.length; ++i) {
            String curWord = words[i];
            String[] cells = this.createCells(true);
            this.extractFeature(curWord, cells);
            cells[5] = iterator.next().label;
            for (int j = 0; j < cells.length; ++j) {
                bw.write(cells[j]);
                if (j == cells.length - 1) continue;
                bw.write(9);
            }
            bw.newLine();
        }
    }

    private String[] createCells(boolean withTag) {
        return withTag ? new String[6] : new String[5];
    }

    private void extractFeature(String curWord, String[] cells) {
        int length = curWord.length();
        cells[0] = curWord;
        cells[1] = curWord.substring(0, 1);
        cells[2] = length > 1 ? curWord.substring(0, 2) : "<>";
        cells[3] = curWord.substring(length - 1);
        cells[4] = length > 1 ? curWord.substring(length - 2) : "<>";
    }

    @Override
    protected String getDefaultFeatureTemplate() {
        return "# Unigram\nU0:%x[-1,0]\nU1:%x[0,0]\nU2:%x[1,0]\nU3:%x[0,1]\nU4:%x[0,2]\nU5:%x[0,3]\nU6:%x[0,4]\n\n# Bigram\nB";
    }

    @Override
    public String[] tag(List<String> wordList) {
        String[] tagArray = new String[wordList.size()];
        TaggerImpl tagger = this.createTagger();
        for (String word : wordList) {
            String[] cells = this.createCells(false);
            this.extractFeature(word, cells);
            tagger.add(cells);
        }
        tagger.parse();
        for (int i = 0; i < tagger.ysize(); ++i) {
            tagArray[i] = tagger.yname(tagger.y(i));
        }
        return tagArray;
    }

    @Override
    public String[] tag(String ... words) {
        String[] tagArray = new String[words.length];
        TaggerImpl tagger = this.createTagger();
        for (String word : words) {
            String[] cells = this.createCells(false);
            this.extractFeature(word, cells);
            tagger.add(cells);
        }
        tagger.parse();
        for (int i = 0; i < tagger.size(); ++i) {
            tagArray[i] = tagger.yname(tagger.y(i));
        }
        return tagArray;
    }
}

