/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.utility;

import com.hankcs.hanlp.corpus.tag.Nature;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;

public class PosTagUtility {
    public static Set<String> tagSet = new LinkedHashSet<String>();

    public static String convert(String tag) {
        for (String t : tagSet) {
            if (!tag.startsWith(t)) continue;
            return t;
        }
        return "n";
    }

    public static String convert(Nature tag) {
        return PosTagUtility.convert(tag.toString());
    }

    static {
        String allTags = "a b c d e f h i j k l m n nr ns nt nu ne nz o p q r s t u v w x y ";
        String[] tagArray = allTags.split("\\s+");
        Arrays.sort(tagArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Integer(o2.length()).compareTo(o1.length());
            }
        });
        for (String tag : tagArray) {
            tagSet.add(tag);
        }
    }
}

