/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.activiti.engine.ActivitiException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.ejb.HibernatePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.orm.hibernate4.HibernateExceptionTranslator;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableJpaRepositories(value={"org.activiti.app.repository"})
@EnableTransactionManagement
public class DatabaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    protected static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_DE_";
    @Inject
    private Environment env;

    @Bean
    public DataSource dataSource() {
        Integer maxIdleTimeExcessConnections;
        Integer maxIdleTime;
        Boolean testConnectionOnCheckOut;
        Integer acquireIncrement;
        Integer maxPoolSize;
        this.log.info("Configuring Datasource");
        String dataSourceJndiName = this.env.getProperty("datasource.jndi.name");
        if (StringUtils.isNotEmpty((CharSequence)dataSourceJndiName)) {
            this.log.info("Using jndi datasource '" + dataSourceJndiName + "'");
            JndiDataSourceLookup dsLookup = new JndiDataSourceLookup();
            dsLookup.setResourceRef(((Boolean)this.env.getProperty("datasource.jndi.resourceRef", Boolean.class, (Object)Boolean.TRUE)).booleanValue());
            DataSource dataSource = dsLookup.getDataSource(dataSourceJndiName);
            return dataSource;
        }
        String dataSourceDriver = this.env.getProperty("datasource.driver", "org.h2.Driver");
        String dataSourceUrl = this.env.getProperty("datasource.url", "jdbc:h2:mem:activiti;DB_CLOSE_DELAY=-1");
        String dataSourceUsername = this.env.getProperty("datasource.username", "sa");
        String dataSourcePassword = this.env.getProperty("datasource.password", "");
        Integer minPoolSize = (Integer)this.env.getProperty("datasource.min-pool-size", Integer.class);
        if (minPoolSize == null) {
            minPoolSize = 10;
        }
        if ((maxPoolSize = (Integer)this.env.getProperty("datasource.max-pool-size", Integer.class)) == null) {
            maxPoolSize = 100;
        }
        if ((acquireIncrement = (Integer)this.env.getProperty("datasource.acquire-increment", Integer.class)) == null) {
            acquireIncrement = 5;
        }
        String preferredTestQuery = this.env.getProperty("datasource.preferred-test-query");
        Boolean testConnectionOnCheckin = (Boolean)this.env.getProperty("datasource.test-connection-on-checkin", Boolean.class);
        if (testConnectionOnCheckin == null) {
            testConnectionOnCheckin = true;
        }
        if ((testConnectionOnCheckOut = (Boolean)this.env.getProperty("datasource.test-connection-on-checkout", Boolean.class)) == null) {
            testConnectionOnCheckOut = true;
        }
        if ((maxIdleTime = (Integer)this.env.getProperty("datasource.max-idle-time", Integer.class)) == null) {
            maxIdleTime = 1800;
        }
        if ((maxIdleTimeExcessConnections = (Integer)this.env.getProperty("datasource.max-idle-time-excess-connections", Integer.class)) == null) {
            maxIdleTimeExcessConnections = 1800;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Configuring Datasource with following properties (omitted password for security)");
            this.log.info("datasource driver: " + dataSourceDriver);
            this.log.info("datasource url : " + dataSourceUrl);
            this.log.info("datasource user name : " + dataSourceUsername);
            this.log.info("Min pool size | Max pool size | acquire increment : " + minPoolSize + " | " + maxPoolSize + " | " + acquireIncrement);
        }
        ComboPooledDataSource ds = new ComboPooledDataSource();
        try {
            ds.setDriverClass(dataSourceDriver);
        }
        catch (PropertyVetoException e) {
            this.log.error("Could not set Jdbc Driver class", (Throwable)e);
            return null;
        }
        ds.setJdbcUrl(dataSourceUrl);
        ds.setUser(dataSourceUsername);
        ds.setPassword(dataSourcePassword);
        ds.setMinPoolSize(minPoolSize.intValue());
        ds.setMaxPoolSize(maxPoolSize.intValue());
        ds.setAcquireIncrement(acquireIncrement.intValue());
        if (preferredTestQuery != null) {
            ds.setPreferredTestQuery(preferredTestQuery);
        }
        ds.setTestConnectionOnCheckin(testConnectionOnCheckin.booleanValue());
        ds.setTestConnectionOnCheckout(testConnectionOnCheckOut.booleanValue());
        ds.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections.intValue());
        ds.setMaxIdleTime(maxIdleTime.intValue());
        return ds;
    }

    @Bean(name={"entityManagerFactory"})
    public EntityManagerFactory entityManagerFactory() {
        this.log.info("Configuring EntityManager");
        LocalContainerEntityManagerFactoryBean lcemfb = new LocalContainerEntityManagerFactoryBean();
        lcemfb.setPersistenceProvider((PersistenceProvider)new HibernatePersistence());
        lcemfb.setPersistenceUnitName("persistenceUnit");
        lcemfb.setDataSource(this.dataSource());
        lcemfb.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        lcemfb.setJpaVendorAdapter(this.jpaVendorAdapter());
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.cache.use_second_level_cache", (Object)false);
        jpaProperties.put("hibernate.generate_statistics", this.env.getProperty("hibernate.generate_statistics", Boolean.class, (Object)false));
        lcemfb.setJpaProperties(jpaProperties);
        lcemfb.setPackagesToScan(new String[]{"org.activiti.app.domain"});
        lcemfb.afterPropertiesSet();
        return lcemfb.getObject();
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
        jpaVendorAdapter.setShowSql(((Boolean)this.env.getProperty("hibernate.show_sql", Boolean.class, (Object)false)).booleanValue());
        jpaVendorAdapter.setDatabasePlatform(this.env.getProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect"));
        return jpaVendorAdapter;
    }

    @Bean
    public HibernateExceptionTranslator hibernateExceptionTranslator() {
        return new HibernateExceptionTranslator();
    }

    @Bean(name={"transactionManager"})
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        JpaTransactionManager jpaTransactionManager = new JpaTransactionManager();
        jpaTransactionManager.setEntityManagerFactory(this.entityManagerFactory());
        return jpaTransactionManager;
    }

    @Bean(name={"liquibase"})
    public Liquibase liquibase() {
        this.log.info("Configuring Liquibase");
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource().getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            Liquibase liquibase = new Liquibase("META-INF/liquibase/activiti-app-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("activiti");
            return liquibase;
        }
        catch (Exception e) {
            throw new ActivitiException("Error creating liquibase database");
        }
    }

    @Bean
    public JdbcTemplate jdbcTemplate() {
        return new JdbcTemplate(this.dataSource());
    }

    @Bean
    public TransactionTemplate transactionTemplate() {
        return new TransactionTemplate(this.annotationDrivenTransactionManager());
    }
}

