/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.ProcessInstanceHelper;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.VariableParsingService;
import org.activiti.spring.process.variable.VariableValidationService;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessVariablesInitiator
extends ProcessInstanceHelper {
    @Autowired
    private Map<String, ProcessExtensionModel> processExtensionDefinitionMap;
    @Autowired
    private VariableParsingService variableParsingService;
    @Autowired
    private VariableValidationService variableValidationService;

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        if (this.processExtensionDefinitionMap.containsKey(processDefinition.getKey())) {
            ProcessExtensionModel processExtensionModel = this.processExtensionDefinitionMap.get(processDefinition.getKey());
            Map<String, VariableDefinition> variableDefinitionMap = processExtensionModel.getExtensions().getProperties();
            Map<String, Object> processedVariables = this.processVariables(variables, variableDefinitionMap);
            Set<String> missingRequiredVars = this.checkRequiredVariables(processedVariables, variableDefinitionMap);
            if (!missingRequiredVars.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' without required variables - " + String.join((CharSequence)", ", missingRequiredVars));
            }
            Set<String> varsWithMismatchedTypes = this.validateVariablesAgainstDefinitions(processedVariables, variableDefinitionMap);
            if (!varsWithMismatchedTypes.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' as variables fail type validation - " + String.join((CharSequence)", ", varsWithMismatchedTypes));
            }
            return super.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, processedVariables, transientVariables, startProcessInstance);
        }
        return super.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, variables, transientVariables, startProcessInstance);
    }

    private Map<String, Object> processVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashMap<String, Object> newVarsMap = new HashMap<String, Object>(variables);
        variableDefinitionMap.forEach((k, v) -> {
            if (!newVarsMap.containsKey(v.getName()) && v.getValue() != null) {
                newVarsMap.put(v.getName(), this.createDefaultVariableValue((VariableDefinition)v));
            }
        });
        return newVarsMap;
    }

    private Object createDefaultVariableValue(VariableDefinition variableDefinition) {
        return this.variableParsingService.parse(variableDefinition);
    }

    private Set<String> checkRequiredVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> missingRequiredVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (!variables.containsKey(v.getName()) && v.isRequired()) {
                missingRequiredVars.add(v.getName());
            }
        });
        return missingRequiredVars;
    }

    private Set<String> validateVariablesAgainstDefinitions(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> mismatchedVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (variables.containsKey(v.getName()) && !this.variableValidationService.validate(variables.get(v.getName()), (VariableDefinition)v)) {
                mismatchedVars.add(v.getName());
            }
        });
        return mismatchedVars;
    }
}

