/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti5.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti5.engine.impl.bpmn.parser.BpmnParse;
import org.activiti5.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.activiti5.engine.impl.el.ExpressionManager;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractActivityBpmnParseHandler<T extends FlowNode>
extends AbstractFlowNodeBpmnParseHandler<T> {
    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        super.parse(bpmnParse, element);
        if (element instanceof Activity && ((Activity)element).getLoopCharacteristics() != null) {
            this.createMultiInstanceLoopCharacteristics(bpmnParse, (Activity)element);
        }
    }

    protected void createMultiInstanceLoopCharacteristics(BpmnParse bpmnParse, Activity modelActivity) {
        MultiInstanceLoopCharacteristics loopCharacteristics = modelActivity.getLoopCharacteristics();
        MultiInstanceActivityBehavior miActivityBehavior = null;
        ActivityImpl activity = bpmnParse.getCurrentScope().findActivity(modelActivity.getId());
        if (activity == null) {
            throw new ActivitiException("Activity " + modelActivity.getId() + " needed for multi instance cannot bv found");
        }
        miActivityBehavior = loopCharacteristics.isSequential() ? bpmnParse.getActivityBehaviorFactory().createSequentialMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior()) : bpmnParse.getActivityBehaviorFactory().createParallelMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior());
        activity.setScope(true);
        activity.setProperty("multiInstance", loopCharacteristics.isSequential() ? "sequential" : "parallel");
        activity.setActivityBehavior(miActivityBehavior);
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getLoopCardinality())) {
            miActivityBehavior.setLoopCardinalityExpression(expressionManager.createExpression(loopCharacteristics.getLoopCardinality()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getCompletionCondition())) {
            miActivityBehavior.setCompletionConditionExpression(expressionManager.createExpression(loopCharacteristics.getCompletionCondition()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getInputDataItem())) {
            if (loopCharacteristics.getInputDataItem().contains("{")) {
                miActivityBehavior.setCollectionExpression(expressionManager.createExpression(loopCharacteristics.getInputDataItem()));
            } else {
                miActivityBehavior.setCollectionVariable(loopCharacteristics.getInputDataItem());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementVariable())) {
            miActivityBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementIndexVariable())) {
            miActivityBehavior.setCollectionElementIndexVariable(loopCharacteristics.getElementIndexVariable());
        }
    }
}

