/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cfg.jta;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.cfg.TransactionContext;
import org.activiti5.engine.impl.cfg.TransactionListener;
import org.activiti5.engine.impl.cfg.TransactionState;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;

public class JtaTransactionContext
implements TransactionContext {
    protected final TransactionManager transactionManager;

    public JtaTransactionContext(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
        try {
            Transaction transaction = this.getTransaction();
            int status = transaction.getStatus();
            if (status != 6 && status != 4) {
                transaction.setRollbackOnly();
            }
        }
        catch (IllegalStateException e) {
            throw new ActivitiException("Unexpected IllegalStateException while marking transaction rollback only");
        }
        catch (SystemException e) {
            throw new ActivitiException("SystemException while marking transaction rollback only");
        }
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new ActivitiException("SystemException while getting transaction ", e);
        }
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        Transaction transaction = this.getTransaction();
        CommandContext commandContext = Context.getCommandContext();
        try {
            transaction.registerSynchronization((Synchronization)new TransactionStateSynchronization(transactionState, transactionListener, commandContext));
        }
        catch (IllegalStateException e) {
            throw new ActivitiException("IllegalStateException while registering synchronization ", e);
        }
        catch (RollbackException e) {
            throw new ActivitiException("RollbackException while registering synchronization ", e);
        }
        catch (SystemException e) {
            throw new ActivitiException("SystemException while registering synchronization ", e);
        }
    }

    public static class TransactionStateSynchronization
    implements Synchronization {
        protected final TransactionListener transactionListener;
        protected final TransactionState transactionState;
        private final CommandContext commandContext;

        public TransactionStateSynchronization(TransactionState transactionState, TransactionListener transactionListener, CommandContext commandContext) {
            this.transactionState = transactionState;
            this.transactionListener = transactionListener;
            this.commandContext = commandContext;
        }

        public void beforeCompletion() {
            if (TransactionState.COMMITTING.equals((Object)this.transactionState) || TransactionState.ROLLINGBACK.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            }
        }

        public void afterCompletion(int status) {
            if (4 == status && TransactionState.ROLLED_BACK.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            } else if (3 == status && TransactionState.COMMITTED.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            }
        }
    }
}

