/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.task.IdentityLink;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti5.engine.impl.persistence.entity.TaskEntity;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetIdentityLinksForTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
        if (task.getAssignee() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getAssignee());
            identityLink.setType("assignee");
            identityLink.setTaskId(task.getId());
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getOwner());
            identityLink.setTaskId(task.getId());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return task.getIdentityLinks();
    }
}

