/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.TaskEntity;
import org.activiti5.engine.task.Task;

public class GetTaskVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;

    public GetTaskVariableCmd(String taskId, String variableName, boolean isLocal) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        Object value = this.isLocal ? task.getVariableLocal(this.variableName, false) : task.getVariable(this.variableName, false);
        return value;
    }
}

