/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.task.Attachment;

public class SaveAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Attachment attachment;

    public SaveAttachmentCmd(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity updateAttachment = commandContext.getDbSqlSession().selectById(AttachmentEntity.class, this.attachment.getId());
        updateAttachment.setName(this.attachment.getName());
        updateAttachment.setDescription(this.attachment.getDescription());
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = updateAttachment.getProcessInstanceId();
            if (updateAttachment.getProcessInstanceId() != null && (process = commandContext.getExecutionEntityManager().findExecutionById(processInstanceId)) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this.attachment, processInstanceId, processInstanceId, processDefinitionId));
        }
        return null;
    }
}

