/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.event.logger.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.event.logger.handler.EventLoggerEventHandler;
import org.activiti5.engine.impl.identity.Authentication;
import org.activiti5.engine.impl.persistence.entity.EventLogEntryEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseEventLoggerEventHandler
implements EventLoggerEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDatabaseEventLoggerEventHandler.class);
    protected ActivitiEvent event;
    protected Date timeStamp;
    protected ObjectMapper objectMapper;

    protected EventLogEntryEntity createEventLogEntry(Map<String, Object> data) {
        return this.createEventLogEntry(null, null, null, null, data);
    }

    protected EventLogEntryEntity createEventLogEntry(String processDefinitionId, String processInstanceId, String executionId, String taskId, Map<String, Object> data) {
        return this.createEventLogEntry(this.event.getType().name(), processDefinitionId, processInstanceId, executionId, taskId, data);
    }

    protected EventLogEntryEntity createEventLogEntry(String type, String processDefinitionId, String processInstanceId, String executionId, String taskId, Map<String, Object> data) {
        ProcessDefinition processDefinition;
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache;
        EventLogEntryEntity eventLogEntry = new EventLogEntryEntity();
        eventLogEntry.setProcessDefinitionId(processDefinitionId);
        eventLogEntry.setProcessInstanceId(processInstanceId);
        eventLogEntry.setExecutionId(executionId);
        eventLogEntry.setTaskId(taskId);
        eventLogEntry.setType(type);
        eventLogEntry.setTimeStamp(this.timeStamp);
        this.putInMapIfNotNull(data, "timeStamp", this.timeStamp);
        String userId = Authentication.getAuthenticatedUserId();
        if (userId != null) {
            eventLogEntry.setUserId(userId);
            this.putInMapIfNotNull(data, "userId", userId);
        }
        if (!data.containsKey("tenantId") && processDefinitionId != null && (processDefinitionCache = Context.getProcessEngineConfiguration().getProcessDefinitionCache()) != null && (processDefinition = ((ProcessDefinitionCacheEntry)processDefinitionCache.get(processDefinitionId)).getProcessDefinition()) != null && !"".equals(processDefinition.getTenantId())) {
            this.putInMapIfNotNull(data, "tenantId", processDefinition.getTenantId());
        }
        try {
            eventLogEntry.setData(this.objectMapper.writeValueAsBytes(data));
        }
        catch (Exception e) {
            logger.warn("Could not serialize event data. Data will not be written to the database", (Throwable)e);
        }
        return eventLogEntry;
    }

    @Override
    public void setEvent(ActivitiEvent event) {
        this.event = event;
    }

    @Override
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T getEntityFromEvent() {
        return (T)((ActivitiEntityEvent)this.event).getEntity();
    }

    public void putInMapIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

