/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.DeploymentQueryImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti5.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti5.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.ModelEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.persistence.entity.ResourceEntity;
import org.activiti5.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti5.engine.repository.Deployment;
import org.activiti5.engine.repository.Model;

public class DeploymentEntityManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbSqlSession().insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        String processDefinitionId;
        List processDefinitions = this.getDbSqlSession().createProcessDefinitionQuery().deploymentId(deploymentId).list();
        List models = this.getDbSqlSession().createModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelManager().updateModel(modelEntity);
        }
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", cascade);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
            List<EventSubscriptionEntity> eventSubscriptionEntities = this.getEventSubscriptionManager().findEventSubscriptionsByTypeAndProcessDefinitionId(null, processDefinitionId, processDefinition.getTenantId());
            Iterator<EventSubscriptionEntity> iterator = eventSubscriptionEntities.iterator();
            while (iterator.hasNext()) {
                EventSubscriptionEntity eventSubscriptionEntity = iterator.next();
                eventSubscriptionEntity.delete();
            }
            this.getProcessDefinitionInfoManager().deleteProcessDefinitionInfo(processDefinitionId);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            List<Job> timerStartJobs = Context.getCommandContext().getTimerJobEntityManager().findTimerJobsByTypeAndProcessDefinitionId("timer-start-event", processDefinition.getId());
            if (timerStartJobs == null || timerStartJobs.size() <= 0) continue;
            for (Job timerStartJob : timerStartJobs) {
                if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerStartJob, null, null, processDefinition.getId()));
                }
                ((TimerJobEntity)timerStartJob).delete();
            }
        }
        this.getProcessDefinitionManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            List signalEventDefinitions;
            ProcessDefinition previousProcessDefinition;
            ProcessDefinitionEntity latestProcessDefinition = this.findLatestProcessDefinition(processDefinition);
            if (!processDefinition.getId().equals(latestProcessDefinition.getId()) || (previousProcessDefinition = this.findNewLatestProcessDefinitionAfterRemovalOf(processDefinition)) == null) continue;
            ProcessDefinitionEntity resolvedProcessDefinition = (ProcessDefinitionEntity)Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition((ProcessDefinitionEntity)previousProcessDefinition).getProcessDefinition();
            List timerDeclarations = (List)resolvedProcessDefinition.getProperty("timerStart");
            if (timerDeclarations != null) {
                for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                    TimerJobEntity timer = timerDeclaration.prepareTimerEntity(null);
                    timer.setProcessDefinitionId(previousProcessDefinition.getId());
                    if (previousProcessDefinition.getTenantId() != null) {
                        timer.setTenantId(previousProcessDefinition.getTenantId());
                    }
                    Context.getCommandContext().getJobEntityManager().schedule(timer);
                }
            }
            if ((signalEventDefinitions = (List)resolvedProcessDefinition.getProperty("eventDefinitions")) == null) continue;
            for (EventSubscriptionDeclaration eventDefinition : signalEventDefinitions) {
                if (eventDefinition.getEventType().equals("signal") && eventDefinition.isStartEvent()) {
                    SignalEventSubscriptionEntity subscriptionEntity = new SignalEventSubscriptionEntity();
                    subscriptionEntity.setEventName(eventDefinition.getEventName());
                    subscriptionEntity.setActivityId(eventDefinition.getActivityId());
                    subscriptionEntity.setProcessDefinitionId(previousProcessDefinition.getId());
                    subscriptionEntity.setTenantId(previousProcessDefinition.getTenantId());
                    subscriptionEntity.insert();
                    continue;
                }
                if (!eventDefinition.getEventType().equals("message") || !eventDefinition.isStartEvent()) continue;
                MessageEventSubscriptionEntity newSubscription = new MessageEventSubscriptionEntity();
                newSubscription.setEventName(eventDefinition.getEventName());
                newSubscription.setActivityId(eventDefinition.getActivityId());
                newSubscription.setConfiguration(previousProcessDefinition.getId());
                newSubscription.setProcessDefinitionId(previousProcessDefinition.getId());
                newSubscription.setTenantId(previousProcessDefinition.getTenantId());
                newSubscription.insert();
            }
        }
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.getDbSqlSession().delete("deleteDeployment", deploymentId);
    }

    protected ProcessDefinitionEntity findLatestProcessDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionEntity latestProcessDefinition = null;
        latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
        return latestProcessDefinition;
    }

    protected ProcessDefinition findNewLatestProcessDefinitionAfterRemovalOf(ProcessDefinition processDefinitionToBeRemoved) {
        ProcessDefinitionQueryImpl query = new ProcessDefinitionQueryImpl();
        query.processDefinitionKey(processDefinitionToBeRemoved.getKey());
        if (processDefinitionToBeRemoved.getTenantId() != null && !"".equals(processDefinitionToBeRemoved.getTenantId())) {
            query.processDefinitionTenantId(processDefinitionToBeRemoved.getTenantId());
        } else {
            query.processDefinitionWithoutTenantId();
        }
        query.processDefinitionVersionLowerThan(processDefinitionToBeRemoved.getVersion());
        query.orderByProcessDefinitionVersion().desc();
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionManager().findProcessDefinitionsByQueryCriteria(query, new Page(0, 1));
        if (processDefinitions != null && processDefinitions.size() > 0) {
            return processDefinitions.get(0);
        }
        return null;
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return (DeploymentEntity)this.getDbSqlSession().selectOne("selectDeploymentById", deploymentId);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectResourceNamesByDeploymentId", (Object)deploymentId);
    }

    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDeploymentByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByNativeQuery", parameterMap);
    }
}

