/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti5.engine.history.HistoricVariableInstance;
import org.activiti5.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.db.PersistentObject;
import org.activiti5.engine.impl.history.HistoryLevel;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricVariableInstanceEntityManager
extends AbstractManager {
    public void deleteHistoricVariableInstanceByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List historicProcessVariables = this.getDbSqlSession().createHistoricVariableInstanceQuery().processInstanceId(historicProcessInstanceId).excludeVariableInitialization().list();
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                historicProcessVariable.delete();
            }
            List<HistoricVariableInstanceEntity> cachedHistoricVariableInstances = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity historicProcessVariable : cachedHistoricVariableInstances) {
                if (!historicProcessInstanceId.equals(historicProcessVariable.getProcessInstanceId())) continue;
                historicProcessVariable.delete();
            }
        }
    }

    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByQueryCriteria", historicProcessVariableQuery);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery, Page page) {
        return this.getDbSqlSession().selectList("selectHistoricVariableInstanceByQueryCriteria", historicProcessVariableQuery, page);
    }

    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return (HistoricVariableInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceByVariableInstanceId", variableInstanceId);
    }

    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List historicProcessVariables = new HistoricVariableInstanceQueryImpl().taskId(taskId).list();
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                ((HistoricVariableInstanceEntity)historicProcessVariable).delete();
            }
        }
    }

    @Override
    public void delete(PersistentObject persistentObject) {
        HistoricVariableInstanceEntity variableInstanceEntity = (HistoricVariableInstanceEntity)persistentObject;
        variableInstanceEntity.delete();
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricVariableInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricVariableInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByNativeQuery", parameterMap);
    }
}

