/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.identity.Group;
import org.activiti5.engine.identity.Picture;
import org.activiti5.engine.identity.User;
import org.activiti5.engine.identity.UserQuery;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.UserQueryImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.db.DbSqlSession;
import org.activiti5.engine.impl.db.PersistentObject;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti5.engine.impl.persistence.entity.UserEntity;
import org.activiti5.engine.impl.persistence.entity.UserIdentityManager;

public class UserEntityManager
extends AbstractManager
implements UserIdentityManager {
    @Override
    public User createNewUser(String userId) {
        return new UserEntity(userId);
    }

    @Override
    public void insertUser(User user) {
        this.getDbSqlSession().insert((PersistentObject)((Object)user));
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, user));
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, user));
        }
    }

    @Override
    public void updateUser(User updatedUser) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update((PersistentObject)((Object)updatedUser));
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, updatedUser));
        }
    }

    @Override
    public User findUserById(String userId) {
        return (UserEntity)this.getDbSqlSession().selectOne("selectUserById", userId);
    }

    @Override
    public void deleteUser(String userId) {
        UserEntity user = (UserEntity)this.findUserById(userId);
        if (user != null) {
            List identityInfos = this.getDbSqlSession().selectList("selectIdentityInfoByUserId", userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoManager().deleteIdentityInfo(identityInfo);
            }
            this.getDbSqlSession().delete("deleteMembershipsByUserId", userId);
            user.delete();
            if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, user));
            }
        }
    }

    @Override
    public List<User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectUserByQueryCriteria", query, page);
    }

    @Override
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectUserCountByQueryCriteria", query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.getDbSqlSession().selectList("selectGroupsByUserId", userId);
    }

    @Override
    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutor());
    }

    @Override
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("key", key);
        return (IdentityInfoEntity)this.getDbSqlSession().selectOne("selectIdentityInfoByUserIdAndKey", parameters);
    }

    @Override
    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("type", type);
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoKeysByUserIdAndType", parameters);
    }

    @Override
    public Boolean checkPassword(String userId, String password) {
        User user = this.findUserById(userId);
        if (user != null && password != null && password.equals(user.getPassword())) {
            return true;
        }
        return false;
    }

    @Override
    public List<User> findPotentialStarterUsers(String proceDefId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("procDefId", proceDefId);
        return (List)this.getDbSqlSession().selectOne("selectUserByQueryCriteria", parameters);
    }

    @Override
    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectUserByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectUserCountByNativeQuery", parameterMap);
    }

    @Override
    public boolean isNewUser(User user) {
        return ((UserEntity)user).getRevision() == 0;
    }

    @Override
    public Picture getUserPicture(String userId) {
        UserEntity user = (UserEntity)this.findUserById(userId);
        return user.getPicture();
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        UserEntity user = (UserEntity)this.findUserById(userId);
        if (user == null) {
            throw new ActivitiObjectNotFoundException("user " + userId + " doesn't exist", User.class);
        }
        user.setPicture(picture);
    }
}

