/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonType
implements VariableType {
    private static final Logger logger = LoggerFactory.getLogger(JsonType.class);
    protected final int maxLength;
    protected ObjectMapper objectMapper;

    public JsonType(int maxLength, ObjectMapper objectMapper) {
        this.maxLength = maxLength;
        this.objectMapper = objectMapper;
    }

    public String getTypeName() {
        return "json";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        JsonNode jsonValue = null;
        if (valueFields.getTextValue() != null && valueFields.getTextValue().length() > 0) {
            try {
                jsonValue = this.objectMapper.readTree(valueFields.getTextValue());
            }
            catch (Exception e) {
                logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
            }
        }
        return jsonValue;
    }

    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setTextValue(value != null ? value.toString() : null);
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass())) {
            JsonNode jsonValue = (JsonNode)value;
            return jsonValue.toString().length() <= this.maxLength;
        }
        return false;
    }
}

