/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.variable.SerializableType;

public class LongJsonType
extends SerializableType {
    protected final int minLength;
    protected ObjectMapper objectMapper;

    public LongJsonType(int minLength, ObjectMapper objectMapper) {
        this.minLength = minLength;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getTypeName() {
        return "longJson";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass())) {
            JsonNode jsonValue = (JsonNode)value;
            return jsonValue.toString().length() >= this.minLength;
        }
        return false;
    }

    @Override
    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        JsonNode valueNode = (JsonNode)value;
        try {
            return valueNode.toString().getBytes("utf-8");
        }
        catch (Exception e) {
            throw new ActivitiException("Error getting bytes from json variable", e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        JsonNode valueNode = null;
        try {
            valueNode = this.objectMapper.readTree(bytes);
        }
        catch (Exception e) {
            throw new ActivitiException("Error reading json variable", e);
        }
        return valueNode;
    }
}

