/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class StringType
implements VariableType {
    private final int maxLength;

    public StringType(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getTypeName() {
        return "string";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        return valueFields.getTextValue();
    }

    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setTextValue((String)value);
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() <= this.maxLength;
        }
        return false;
    }
}

