/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/admin/v1/process-instances"}, produces={"application/hal+json", "application/json"})
public interface ProcessInstanceAdminController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<Resource<CloudProcessInstance>> getProcessInstances(Pageable var1);

    @RequestMapping(method={RequestMethod.POST})
    public Resource<CloudProcessInstance> startProcess(@RequestBody StartProcessPayload var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public Resource<CloudProcessInstance> getProcessInstanceById(@PathVariable String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"{processInstanceId}/suspend"})
    public Resource<CloudProcessInstance> suspend(@PathVariable String var1);

    @RequestMapping(method={RequestMethod.POST}, value={"{processInstanceId}/resume"})
    public Resource<CloudProcessInstance> resume(@PathVariable String var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.DELETE})
    public Resource<CloudProcessInstance> deleteProcessInstance(@PathVariable String var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.PUT})
    public Resource<CloudProcessInstance> updateProcess(@PathVariable(value="processInstanceId") String var1, @RequestBody UpdateProcessPayload var2);

    @RequestMapping(value={"/{processInstanceId}/subprocesses"}, method={RequestMethod.GET})
    public PagedResources<Resource<CloudProcessInstance>> subprocesses(@PathVariable(value="processInstanceId") String var1, Pageable var2);
}

