/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import java.util.List;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.cloud.api.task.model.CloudTask;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/admin/v1/tasks"}, produces={"application/hal+json", "application/json"})
public interface TaskAdminController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<Resource<CloudTask>> getTasks(Pageable var1);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public Resource<CloudTask> getTaskById(@PathVariable String var1);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.PUT})
    public Resource<CloudTask> updateTask(@PathVariable(value="taskId") String var1, @RequestBody UpdateTaskPayload var2);

    @RequestMapping(value={"/{taskId}/complete"}, method={RequestMethod.POST})
    public Resource<CloudTask> completeTask(@PathVariable String var1, @RequestBody(required=false) CompleteTaskPayload var2);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.DELETE})
    public Resource<CloudTask> deleteTask(@PathVariable String var1);

    @RequestMapping(value={"/{taskId}/assign"}, method={RequestMethod.POST})
    public Resource<CloudTask> assign(@PathVariable(value="taskId") String var1, @RequestBody AssignTaskPayload var2);

    @RequestMapping(value={"/{taskId}/candidate-users"}, method={RequestMethod.POST})
    public void addCandidateUsers(@PathVariable(value="taskId") String var1, @RequestBody CandidateUsersPayload var2);

    @RequestMapping(value={"/{taskId}/candidate-users"}, method={RequestMethod.DELETE})
    public void deleteCandidateUsers(@PathVariable(value="taskId") String var1, @RequestBody CandidateUsersPayload var2);

    @RequestMapping(value={"/{taskId}/candidate-users"}, method={RequestMethod.GET})
    public List<String> getUserCandidates(@PathVariable(value="taskId") String var1);

    @RequestMapping(value={"/{taskId}/candidate-groups"}, method={RequestMethod.POST})
    public void addCandidateGroups(@PathVariable(value="taskId") String var1, @RequestBody CandidateGroupsPayload var2);

    @RequestMapping(value={"/{taskId}/candidate-groups"}, method={RequestMethod.DELETE})
    public void deleteCandidateGroups(@PathVariable(value="taskId") String var1, @RequestBody CandidateGroupsPayload var2);

    @RequestMapping(value={"/{taskId}/candidate-groups"}, method={RequestMethod.GET})
    public List<String> getGroupCandidates(@PathVariable(value="taskId") String var1);
}

