/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.admin;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowDatabasesMergedResult;
import org.apache.shardingsphere.core.rule.ProxyUser;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class ShowDatabasesBackendHandler
implements TextProtocolBackendHandler {
    private final BackendConnection backendConnection;
    private MergedResult mergedResult;

    @Override
    public BackendResponse execute() {
        this.mergedResult = new ShowDatabasesMergedResult(this.getSchemaNames());
        return new QueryResponse(Collections.singletonList(new QueryHeader("information_schema", "SCHEMATA", "Database", "SCHEMA_NAME", 100, 12, 0, false, false, false, false)));
    }

    private List<String> getSchemaNames() {
        LinkedList<String> result = new LinkedList<String>(LogicSchemas.getInstance().getSchemaNames());
        Collection authorizedSchemas = ((ProxyUser)ShardingProxyContext.getInstance().getAuthentication().getUsers().get(this.backendConnection.getUserName())).getAuthorizedSchemas();
        if (!authorizedSchemas.isEmpty()) {
            result.retainAll(authorizedSchemas);
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        return new QueryData(Collections.singletonList(12), Collections.singletonList(this.mergedResult.getValue(1, Object.class)));
    }

    @ConstructorProperties(value={"backendConnection"})
    public ShowDatabasesBackendHandler(BackendConnection backendConnection) {
        this.backendConnection = backendConnection;
    }
}

