/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.ShardingCTLHintStatement;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintAddDatabaseShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintAddTableShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintClearCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintErrorParameterCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintSetDatabaseShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintSetMasterOnlyCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowStatusCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowTableStatusCommand;

public final class ShardingCTLHintParser
implements ShardingCTLParser<ShardingCTLHintStatement> {
    private final String setMasterOnlyRegex = "sctl:hint\\s+set\\s+MASTER_ONLY=(true|false)\\s*$";
    private final String setDatabaseShardingValueRegex = "sctl:hint\\s+set\\s+DatabaseShardingValue=(\\S*)";
    private final String addDatabaseShardingValueRegex = "sctl:hint\\s+addDatabaseShardingValue\\s+(\\S*)=(\\S*)";
    private final String addTableShardingValueRegex = "sctl:hint\\s+addTableShardingValue\\s+(\\S*)=(\\S*)";
    private final String clearRegex = "sctl:hint\\s+clear\\s*$";
    private final String showStatusRegex = "sctl:hint\\s+show\\s+status\\s*$";
    private final String showTableStatusRegex = "sctl:hint\\s+show\\s+table\\s+status\\s*$";
    private final String errorParameterRegex = "sctl:hint\\s+.*";
    private final Matcher setMasterOnlyMatcher;
    private final Matcher setDatabaseShardingValueMatcher;
    private final Matcher addDatabaseShardingValueMatcher;
    private final Matcher addTableShardingValueMatcher;
    private final Matcher clearMatcher;
    private final Matcher showStatusMatcher;
    private final Matcher showTableStatusMatcher;
    private final Matcher errorParameterMatcher;

    public ShardingCTLHintParser(String sql) {
        this.setMasterOnlyMatcher = Pattern.compile("sctl:hint\\s+set\\s+MASTER_ONLY=(true|false)\\s*$", 2).matcher(sql);
        this.setDatabaseShardingValueMatcher = Pattern.compile("sctl:hint\\s+set\\s+DatabaseShardingValue=(\\S*)", 2).matcher(sql);
        this.addDatabaseShardingValueMatcher = Pattern.compile("sctl:hint\\s+addDatabaseShardingValue\\s+(\\S*)=(\\S*)", 2).matcher(sql);
        this.addTableShardingValueMatcher = Pattern.compile("sctl:hint\\s+addTableShardingValue\\s+(\\S*)=(\\S*)", 2).matcher(sql);
        this.clearMatcher = Pattern.compile("sctl:hint\\s+clear\\s*$", 2).matcher(sql);
        this.showStatusMatcher = Pattern.compile("sctl:hint\\s+show\\s+status\\s*$", 2).matcher(sql);
        this.showTableStatusMatcher = Pattern.compile("sctl:hint\\s+show\\s+table\\s+status\\s*$", 2).matcher(sql);
        this.errorParameterMatcher = Pattern.compile("sctl:hint\\s+.*", 2).matcher(sql);
    }

    @Override
    public Optional<ShardingCTLHintStatement> doParse() {
        Optional<ShardingCTLHintStatement> updateShardingCTLHintStatement = this.parseUpdateShardingCTLHintStatement();
        if (updateShardingCTLHintStatement.isPresent()) {
            return updateShardingCTLHintStatement;
        }
        Optional<ShardingCTLHintStatement> queryShardingCTLHintStatement = this.parseQueryShardingCTLHintStatement();
        if (queryShardingCTLHintStatement.isPresent()) {
            return queryShardingCTLHintStatement;
        }
        if (this.errorParameterMatcher.find()) {
            return Optional.of((Object)new ShardingCTLHintStatement(new HintErrorParameterCommand()));
        }
        return Optional.absent();
    }

    private Optional<ShardingCTLHintStatement> parseUpdateShardingCTLHintStatement() {
        if (this.setMasterOnlyMatcher.find()) {
            boolean masterOnly = Boolean.valueOf(this.setMasterOnlyMatcher.group(1).toUpperCase());
            return Optional.of((Object)new ShardingCTLHintStatement(new HintSetMasterOnlyCommand(masterOnly)));
        }
        if (this.setDatabaseShardingValueMatcher.find()) {
            String shardingValue = this.setDatabaseShardingValueMatcher.group(1);
            return Optional.of((Object)new ShardingCTLHintStatement(new HintSetDatabaseShardingValueCommand(shardingValue)));
        }
        if (this.addDatabaseShardingValueMatcher.find()) {
            String logicTable = this.addDatabaseShardingValueMatcher.group(1);
            String shardingValue = this.addDatabaseShardingValueMatcher.group(2);
            return Optional.of((Object)new ShardingCTLHintStatement(new HintAddDatabaseShardingValueCommand(logicTable, shardingValue)));
        }
        if (this.addTableShardingValueMatcher.find()) {
            String logicTable = this.addTableShardingValueMatcher.group(1);
            String shardingValue = this.addTableShardingValueMatcher.group(2);
            return Optional.of((Object)new ShardingCTLHintStatement(new HintAddTableShardingValueCommand(logicTable, shardingValue)));
        }
        if (this.clearMatcher.find()) {
            return Optional.of((Object)new ShardingCTLHintStatement(new HintClearCommand()));
        }
        return Optional.absent();
    }

    private Optional<ShardingCTLHintStatement> parseQueryShardingCTLHintStatement() {
        if (this.showStatusMatcher.find()) {
            return Optional.of((Object)new ShardingCTLHintStatement(new HintShowStatusCommand()));
        }
        if (this.showTableStatusMatcher.find()) {
            return Optional.of((Object)new ShardingCTLHintStatement(new HintShowTableStatusCommand()));
        }
        return Optional.absent();
    }
}

