/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal;

import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommandExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintAddDatabaseShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintAddTableShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintClearCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintSetDatabaseShardingValueCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintSetMasterOnlyCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowStatusCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowTableStatusCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintAddDatabaseShardingValueExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintAddTableShardingValueExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintClearExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintErrorParameterExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintSetDatabaseShardingValueExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintSetMasterOnlyExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintShowStatusExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.HintShowTableStatusExecutor;

public final class HintCommandExecutorFactory {
    public static HintCommandExecutor newInstance(HintCommand hintCommand, BackendConnection backendConnection, String sql) {
        if (hintCommand instanceof HintSetMasterOnlyCommand) {
            return new HintSetMasterOnlyExecutor();
        }
        if (hintCommand instanceof HintSetDatabaseShardingValueCommand) {
            return new HintSetDatabaseShardingValueExecutor();
        }
        if (hintCommand instanceof HintAddDatabaseShardingValueCommand) {
            return new HintAddDatabaseShardingValueExecutor();
        }
        if (hintCommand instanceof HintAddTableShardingValueCommand) {
            return new HintAddTableShardingValueExecutor();
        }
        if (hintCommand instanceof HintClearCommand) {
            return new HintClearExecutor();
        }
        if (hintCommand instanceof HintShowStatusCommand) {
            return new HintShowStatusExecutor();
        }
        if (hintCommand instanceof HintShowTableStatusCommand) {
            return new HintShowTableStatusExecutor(backendConnection);
        }
        return new HintErrorParameterExecutor(sql);
    }

    private HintCommandExecutorFactory() {
    }
}

