/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater;

import org.deeplearning4j.arbiter.conf.updater.BaseUpdaterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AdaMaxSpace
extends BaseUpdaterSpace {
    private ParameterSpace<Double> learningRate;
    private ParameterSpace<ISchedule> learningRateSchedule;
    private ParameterSpace<Double> beta1;
    private ParameterSpace<Double> beta2;
    private ParameterSpace<Double> epsilon;

    public AdaMaxSpace(ParameterSpace<Double> learningRate) {
        this(learningRate, null, null, null);
    }

    public AdaMaxSpace(ParameterSpace<Double> learningRate, ParameterSpace<Double> beta1, ParameterSpace<Double> beta2, ParameterSpace<Double> epsilon) {
        this(learningRate, null, beta1, beta2, epsilon);
    }

    public AdaMaxSpace(@JsonProperty(value="learningRate") ParameterSpace<Double> learningRate, @JsonProperty(value="learningRateSchedule") ParameterSpace<ISchedule> learningRateSchedule, @JsonProperty(value="beta1") ParameterSpace<Double> beta1, @JsonProperty(value="beta2") ParameterSpace<Double> beta2, @JsonProperty(value="epsilon") ParameterSpace<Double> epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    public static AdaMaxSpace withLR(ParameterSpace<Double> lr) {
        return new AdaMaxSpace(lr, null, null, null, null);
    }

    public static AdaMaxSpace withLRSchedule(ParameterSpace<ISchedule> lrSchedule) {
        return new AdaMaxSpace(null, lrSchedule, null, null, null);
    }

    public IUpdater getValue(double[] parameterValues) {
        double eps;
        double lr = this.learningRate == null ? 0.001 : (Double)this.learningRate.getValue(parameterValues);
        ISchedule lrS = this.learningRateSchedule == null ? null : (ISchedule)this.learningRateSchedule.getValue(parameterValues);
        double b1 = this.beta1 == null ? 0.001 : (Double)this.beta1.getValue(parameterValues);
        double b2 = this.beta2 == null ? 0.001 : (Double)this.beta2.getValue(parameterValues);
        double d = eps = this.epsilon == null ? 0.001 : (Double)this.epsilon.getValue(parameterValues);
        if (lrS == null) {
            return new AdaMax(lr, b1, b2, eps);
        }
        AdaMax a = new AdaMax(lrS);
        a.setBeta1(b1);
        a.setBeta2(b2);
        a.setEpsilon(eps);
        return a;
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<ISchedule> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public ParameterSpace<Double> getBeta1() {
        return this.beta1;
    }

    public ParameterSpace<Double> getBeta2() {
        return this.beta2;
    }

    public ParameterSpace<Double> getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ParameterSpace<ISchedule> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setBeta1(ParameterSpace<Double> beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(ParameterSpace<Double> beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(ParameterSpace<Double> epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public String toString() {
        return "AdaMaxSpace(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaMaxSpace)) {
            return false;
        }
        AdaMaxSpace other = (AdaMaxSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<ISchedule> this$learningRateSchedule = this.getLearningRateSchedule();
        ParameterSpace<ISchedule> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        ParameterSpace<Double> this$beta1 = this.getBeta1();
        ParameterSpace<Double> other$beta1 = other.getBeta1();
        if (this$beta1 == null ? other$beta1 != null : !this$beta1.equals(other$beta1)) {
            return false;
        }
        ParameterSpace<Double> this$beta2 = this.getBeta2();
        ParameterSpace<Double> other$beta2 = other.getBeta2();
        if (this$beta2 == null ? other$beta2 != null : !this$beta2.equals(other$beta2)) {
            return false;
        }
        ParameterSpace<Double> this$epsilon = this.getEpsilon();
        ParameterSpace<Double> other$epsilon = other.getEpsilon();
        return !(this$epsilon == null ? other$epsilon != null : !this$epsilon.equals(other$epsilon));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdaMaxSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<ISchedule> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        ParameterSpace<Double> $beta1 = this.getBeta1();
        result = result * 59 + ($beta1 == null ? 43 : $beta1.hashCode());
        ParameterSpace<Double> $beta2 = this.getBeta2();
        result = result * 59 + ($beta2 == null ? 43 : $beta2.hashCode());
        ParameterSpace<Double> $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : $epsilon.hashCode());
        return result;
    }
}

