/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater;

import org.deeplearning4j.arbiter.conf.updater.BaseUpdaterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class NesterovsSpace
extends BaseUpdaterSpace {
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<ISchedule> learningRateSchedule;
    protected ParameterSpace<Double> momentum;
    protected ParameterSpace<ISchedule> momentumSchedule;

    public NesterovsSpace(ParameterSpace<Double> learningRate) {
        this(learningRate, null);
    }

    public NesterovsSpace(ParameterSpace<Double> learningRate, ParameterSpace<Double> momentum) {
        this(learningRate, null, momentum, null);
    }

    public NesterovsSpace(@JsonProperty(value="learningRate") ParameterSpace<Double> learningRate, @JsonProperty(value="learningRateSchedule") ParameterSpace<ISchedule> learningRateSchedule, @JsonProperty(value="momentum") ParameterSpace<Double> momentum, @JsonProperty(value="momentumSchedule") ParameterSpace<ISchedule> momentumSchedule) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.momentum = momentum;
        this.momentumSchedule = momentumSchedule;
    }

    public static NesterovsSpace withLR(ParameterSpace<Double> lr) {
        return new NesterovsSpace(lr, null, null, null);
    }

    public static NesterovsSpace withLR(ParameterSpace<Double> lr, double momentum) {
        return new NesterovsSpace(lr, null, (ParameterSpace<Double>)new FixedValue((Object)momentum), null);
    }

    public static NesterovsSpace withLR(ParameterSpace<Double> lr, ParameterSpace<Double> momentum) {
        return new NesterovsSpace(lr, null, momentum, null);
    }

    public static NesterovsSpace withLRSchedule(ParameterSpace<ISchedule> lrSchedule) {
        return new NesterovsSpace(null, lrSchedule, null, null);
    }

    public static NesterovsSpace withLRSchedule(ParameterSpace<ISchedule> lrSchedule, double momentum) {
        return new NesterovsSpace(null, lrSchedule, (ParameterSpace<Double>)new FixedValue((Object)momentum), null);
    }

    public static NesterovsSpace withLRSchedule(ParameterSpace<ISchedule> lrSchedule, ParameterSpace<Double> momentum) {
        return new NesterovsSpace(null, lrSchedule, momentum, null);
    }

    public IUpdater getValue(double[] parameterValues) {
        ISchedule mS;
        double lr = this.learningRate == null ? 0.1 : (Double)this.learningRate.getValue(parameterValues);
        ISchedule lrS = this.learningRateSchedule == null ? null : (ISchedule)this.learningRateSchedule.getValue(parameterValues);
        double m = this.momentum == null ? 0.9 : (Double)this.momentum.getValue(parameterValues);
        ISchedule iSchedule = mS = this.momentumSchedule == null ? null : (ISchedule)this.momentumSchedule.getValue(parameterValues);
        if (lrS == null) {
            if (this.momentumSchedule == null) {
                return new Nesterovs(lr, m);
            }
            return new Nesterovs(lr, mS);
        }
        if (this.momentumSchedule == null) {
            return new Nesterovs(lrS, m);
        }
        return new Nesterovs(lrS, mS);
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<ISchedule> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public ParameterSpace<Double> getMomentum() {
        return this.momentum;
    }

    public ParameterSpace<ISchedule> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ParameterSpace<ISchedule> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setMomentum(ParameterSpace<Double> momentum) {
        this.momentum = momentum;
    }

    public void setMomentumSchedule(ParameterSpace<ISchedule> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    @Override
    public String toString() {
        return "NesterovsSpace(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NesterovsSpace)) {
            return false;
        }
        NesterovsSpace other = (NesterovsSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<ISchedule> this$learningRateSchedule = this.getLearningRateSchedule();
        ParameterSpace<ISchedule> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        ParameterSpace<Double> this$momentum = this.getMomentum();
        ParameterSpace<Double> other$momentum = other.getMomentum();
        if (this$momentum == null ? other$momentum != null : !this$momentum.equals(other$momentum)) {
            return false;
        }
        ParameterSpace<ISchedule> this$momentumSchedule = this.getMomentumSchedule();
        ParameterSpace<ISchedule> other$momentumSchedule = other.getMomentumSchedule();
        return !(this$momentumSchedule == null ? other$momentumSchedule != null : !this$momentumSchedule.equals(other$momentumSchedule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NesterovsSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<ISchedule> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        ParameterSpace<Double> $momentum = this.getMomentum();
        result = result * 59 + ($momentum == null ? 43 : $momentum.hashCode());
        ParameterSpace<ISchedule> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : $momentumSchedule.hashCode());
        return result;
    }
}

