/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater.schedule;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.linalg.schedule.StepSchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class StepScheduleSpace
implements ParameterSpace<ISchedule> {
    private ScheduleType scheduleType;
    private ParameterSpace<Double> initialValue;
    private ParameterSpace<Double> decayRate;
    private ParameterSpace<Double> step;

    public StepScheduleSpace(@NonNull ScheduleType scheduleType, @NonNull ParameterSpace<Double> initialValue, double decayRate, double step) {
        this(scheduleType, initialValue, (ParameterSpace<Double>)new FixedValue((Object)decayRate), (ParameterSpace<Double>)new FixedValue((Object)step));
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked @NonNull but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked @NonNull but is null");
        }
    }

    public StepScheduleSpace(@JsonProperty(value="scheduleType") @NonNull ScheduleType scheduleType, @JsonProperty(value="initialValue") @NonNull ParameterSpace<Double> initialValue, @JsonProperty(value="decayRate") @NonNull ParameterSpace<Double> decayRate, @JsonProperty(value="step") @NonNull ParameterSpace<Double> step) {
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked @NonNull but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked @NonNull but is null");
        }
        if (decayRate == null) {
            throw new NullPointerException("decayRate is marked @NonNull but is null");
        }
        if (step == null) {
            throw new NullPointerException("step is marked @NonNull but is null");
        }
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.decayRate = decayRate;
        this.step = step;
    }

    public ISchedule getValue(double[] parameterValues) {
        return new StepSchedule(this.scheduleType, ((Double)this.initialValue.getValue(parameterValues)).doubleValue(), ((Double)this.decayRate.getValue(parameterValues)).doubleValue(), ((Double)this.step.getValue(parameterValues)).doubleValue());
    }

    public int numParameters() {
        return this.initialValue.numParameters() + this.decayRate.numParameters() + this.step.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Arrays.asList(this.initialValue, this.decayRate, this.step);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        LinkedHashMap<String, ParameterSpace> out = new LinkedHashMap<String, ParameterSpace>();
        out.put("initialValue", this.initialValue);
        out.put("decayRate", this.decayRate);
        out.put("step", this.step);
        return out;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        int[] sub;
        if (this.initialValue.numParameters() > 0) {
            int[] sub2 = Arrays.copyOfRange(indices, 0, this.initialValue.numParameters());
            this.initialValue.setIndices(sub2);
        }
        if (this.decayRate.numParameters() > 0) {
            int inp = this.initialValue.numParameters();
            sub = Arrays.copyOfRange(indices, inp, inp + this.decayRate.numParameters());
            this.decayRate.setIndices(sub);
        }
        if (this.step.numParameters() > 0) {
            int np = this.initialValue.numParameters() + this.decayRate.numParameters();
            sub = Arrays.copyOfRange(indices, np, np + this.step.numParameters());
            this.step.setIndices(sub);
        }
    }

    public StepScheduleSpace() {
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public ParameterSpace<Double> getInitialValue() {
        return this.initialValue;
    }

    public ParameterSpace<Double> getDecayRate() {
        return this.decayRate;
    }

    public ParameterSpace<Double> getStep() {
        return this.step;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setInitialValue(ParameterSpace<Double> initialValue) {
        this.initialValue = initialValue;
    }

    public void setDecayRate(ParameterSpace<Double> decayRate) {
        this.decayRate = decayRate;
    }

    public void setStep(ParameterSpace<Double> step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepScheduleSpace)) {
            return false;
        }
        StepScheduleSpace other = (StepScheduleSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
            return false;
        }
        ParameterSpace<Double> this$initialValue = this.getInitialValue();
        ParameterSpace<Double> other$initialValue = other.getInitialValue();
        if (this$initialValue == null ? other$initialValue != null : !this$initialValue.equals(other$initialValue)) {
            return false;
        }
        ParameterSpace<Double> this$decayRate = this.getDecayRate();
        ParameterSpace<Double> other$decayRate = other.getDecayRate();
        if (this$decayRate == null ? other$decayRate != null : !this$decayRate.equals(other$decayRate)) {
            return false;
        }
        ParameterSpace<Double> this$step = this.getStep();
        ParameterSpace<Double> other$step = other.getStep();
        return !(this$step == null ? other$step != null : !this$step.equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StepScheduleSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
        ParameterSpace<Double> $initialValue = this.getInitialValue();
        result = result * 59 + ($initialValue == null ? 43 : $initialValue.hashCode());
        ParameterSpace<Double> $decayRate = this.getDecayRate();
        result = result * 59 + ($decayRate == null ? 43 : $decayRate.hashCode());
        ParameterSpace<Double> $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : $step.hashCode());
        return result;
    }

    public String toString() {
        return "StepScheduleSpace(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", decayRate=" + this.getDecayRate() + ", step=" + this.getStep() + ")";
    }
}

