/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.dropout;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.dropout.GaussianDropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;

public class GaussianDropoutSpace
implements ParameterSpace<IDropout> {
    private ParameterSpace<Double> rate;

    public GaussianDropoutSpace(double rate) {
        this((ParameterSpace<Double>)new FixedValue((Object)rate));
    }

    public IDropout getValue(double[] parameterValues) {
        return new GaussianDropout(((Double)this.rate.getValue(parameterValues)).doubleValue());
    }

    public int numParameters() {
        return this.rate.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this.rate);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.singletonMap("rate", this.rate);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        this.rate.setIndices(indices);
    }

    public GaussianDropoutSpace(ParameterSpace<Double> rate) {
        this.rate = rate;
    }
}

