/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.dropout;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.dropout.GaussianNoise;
import org.deeplearning4j.nn.conf.dropout.IDropout;

public class GaussianNoiseSpace
implements ParameterSpace<IDropout> {
    private ParameterSpace<Double> stddev;

    public GaussianNoiseSpace(double stddev) {
        this((ParameterSpace<Double>)new FixedValue((Object)stddev));
    }

    public IDropout getValue(double[] parameterValues) {
        return new GaussianNoise(((Double)this.stddev.getValue(parameterValues)).doubleValue());
    }

    public int numParameters() {
        return this.stddev.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this.stddev);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.singletonMap("stddev", this.stddev);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        this.stddev.setIndices(indices);
    }

    public GaussianNoiseSpace(ParameterSpace<Double> stddev) {
        this.stddev = stddev;
    }
}

