/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.AbstractLSTM;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;

public abstract class AbstractLSTMLayerSpace<T extends AbstractLSTM>
extends FeedForwardLayerSpace<T> {
    protected ParameterSpace<Double> forgetGateBiasInit;
    protected ParameterSpace<IActivation> gateActivationFn;

    protected AbstractLSTMLayerSpace(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
        this.gateActivationFn = builder.gateActivationFn;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    protected void setLayerOptionsBuilder(AbstractLSTM.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.forgetGateBiasInit != null) {
            builder.forgetGateBiasInit(((Double)this.forgetGateBiasInit.getValue(values)).doubleValue());
        }
        if (this.gateActivationFn != null) {
            builder.gateActivationFunction((IActivation)this.gateActivationFn.getValue(values));
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        if (this.forgetGateBiasInit != null) {
            sb.append("forgetGateBiasInit: ").append(this.forgetGateBiasInit).append(delim);
        }
        if (this.gateActivationFn != null) {
            sb.append("gateActivationFn: ").append(this.gateActivationFn).append(delim);
        }
        sb.append(super.toString(delim));
        return sb.toString();
    }

    public ParameterSpace<Double> getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public ParameterSpace<IActivation> getGateActivationFn() {
        return this.gateActivationFn;
    }

    public void setForgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    public void setGateActivationFn(ParameterSpace<IActivation> gateActivationFn) {
        this.gateActivationFn = gateActivationFn;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLSTMLayerSpace)) {
            return false;
        }
        AbstractLSTMLayerSpace other = (AbstractLSTMLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$forgetGateBiasInit = this.getForgetGateBiasInit();
        ParameterSpace<Double> other$forgetGateBiasInit = other.getForgetGateBiasInit();
        if (this$forgetGateBiasInit == null ? other$forgetGateBiasInit != null : !this$forgetGateBiasInit.equals(other$forgetGateBiasInit)) {
            return false;
        }
        ParameterSpace<IActivation> this$gateActivationFn = this.getGateActivationFn();
        ParameterSpace<IActivation> other$gateActivationFn = other.getGateActivationFn();
        return !(this$gateActivationFn == null ? other$gateActivationFn != null : !this$gateActivationFn.equals(other$gateActivationFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLSTMLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Double> $forgetGateBiasInit = this.getForgetGateBiasInit();
        result = result * 59 + ($forgetGateBiasInit == null ? 43 : $forgetGateBiasInit.hashCode());
        ParameterSpace<IActivation> $gateActivationFn = this.getGateActivationFn();
        result = result * 59 + ($gateActivationFn == null ? 43 : $gateActivationFn.hashCode());
        return result;
    }

    protected AbstractLSTMLayerSpace() {
    }

    public static abstract class Builder<T>
    extends FeedForwardLayerSpace.Builder<T> {
        private ParameterSpace<Double> forgetGateBiasInit;
        private ParameterSpace<IActivation> gateActivationFn;

        public T forgetGateBiasInit(double forgetGateBiasInit) {
            return this.forgetGateBiasInit((ParameterSpace<Double>)new FixedValue((Object)forgetGateBiasInit));
        }

        public T forgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
            this.forgetGateBiasInit = forgetGateBiasInit;
            return (T)this;
        }

        public T gateActivationFn(Activation activation) {
            return this.gateActivationFn(activation.getActivationFunction());
        }

        public T gateActivation(ParameterSpace<Activation> gateActivationFn) {
            return this.gateActivationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(gateActivationFn));
        }

        public T gateActivationFn(IActivation gateActivationFn) {
            return this.gateActivationFn((ParameterSpace<IActivation>)new FixedValue((Object)gateActivationFn));
        }

        public T gateActivationFn(ParameterSpace<IActivation> gateActivationFn) {
            this.gateActivationFn = gateActivationFn;
            return (T)this;
        }
    }
}

