/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AutoEncoderLayerSpace
extends BasePretrainNetworkLayerSpace<AutoEncoder> {
    @JsonProperty
    private ParameterSpace<Double> corruptionLevel;
    @JsonProperty
    private ParameterSpace<Double> sparsity;

    private AutoEncoderLayerSpace(Builder builder) {
        super(builder);
        this.corruptionLevel = builder.corruptionLevel;
        this.sparsity = builder.sparsity;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public AutoEncoder getValue(double[] values) {
        AutoEncoder.Builder b = new AutoEncoder.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(AutoEncoder.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.corruptionLevel != null) {
            builder.corruptionLevel(((Double)this.corruptionLevel.getValue(values)).doubleValue());
        }
        if (this.sparsity != null) {
            builder.sparsity(((Double)this.sparsity.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("AutoEncoderLayerSpace(");
        if (this.corruptionLevel != null) {
            sb.append("corruptionLevel: ").append(this.corruptionLevel).append(delim);
        }
        if (this.sparsity != null) {
            sb.append("sparsity: ").append(this.sparsity).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<Double> getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public ParameterSpace<Double> getSparsity() {
        return this.sparsity;
    }

    public void setCorruptionLevel(ParameterSpace<Double> corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public void setSparsity(ParameterSpace<Double> sparsity) {
        this.sparsity = sparsity;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoEncoderLayerSpace)) {
            return false;
        }
        AutoEncoderLayerSpace other = (AutoEncoderLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$corruptionLevel = this.getCorruptionLevel();
        ParameterSpace<Double> other$corruptionLevel = other.getCorruptionLevel();
        if (this$corruptionLevel == null ? other$corruptionLevel != null : !this$corruptionLevel.equals(other$corruptionLevel)) {
            return false;
        }
        ParameterSpace<Double> this$sparsity = this.getSparsity();
        ParameterSpace<Double> other$sparsity = other.getSparsity();
        return !(this$sparsity == null ? other$sparsity != null : !this$sparsity.equals(other$sparsity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoEncoderLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Double> $corruptionLevel = this.getCorruptionLevel();
        result = result * 59 + ($corruptionLevel == null ? 43 : $corruptionLevel.hashCode());
        ParameterSpace<Double> $sparsity = this.getSparsity();
        result = result * 59 + ($sparsity == null ? 43 : $sparsity.hashCode());
        return result;
    }

    private AutoEncoderLayerSpace() {
    }

    public static class Builder
    extends BasePretrainNetworkLayerSpace.Builder<Builder> {
        private ParameterSpace<Double> corruptionLevel;
        private ParameterSpace<Double> sparsity;

        public Builder corruptionLevel(double corruptionLevel) {
            return this.corruptionLevel((ParameterSpace<Double>)new FixedValue((Object)corruptionLevel));
        }

        public Builder corruptionLevel(ParameterSpace<Double> corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
            return this;
        }

        public Builder sparsity(double sparsity) {
            return this.sparsity((ParameterSpace<Double>)new FixedValue((Object)sparsity));
        }

        public Builder sparsity(ParameterSpace<Double> sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @Override
        public AutoEncoderLayerSpace build() {
            return new AutoEncoderLayerSpace(this);
        }
    }
}

