/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.adapter.LossFunctionParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public abstract class BaseOutputLayerSpace<L extends BaseOutputLayer>
extends FeedForwardLayerSpace<L> {
    protected ParameterSpace<ILossFunction> lossFunction;
    protected ParameterSpace<Boolean> hasBias;

    protected BaseOutputLayerSpace(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.hasBias = builder.hasBias;
    }

    protected void setLayerOptionsBuilder(BaseOutputLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.lossFunction != null) {
            builder.lossFunction((ILossFunction)this.lossFunction.getValue(values));
        }
        if (this.hasBias != null) {
            builder.hasBias(((Boolean)this.hasBias.getValue(values)).booleanValue());
        }
    }

    public ParameterSpace<ILossFunction> getLossFunction() {
        return this.lossFunction;
    }

    public ParameterSpace<Boolean> getHasBias() {
        return this.hasBias;
    }

    public void setLossFunction(ParameterSpace<ILossFunction> lossFunction) {
        this.lossFunction = lossFunction;
    }

    public void setHasBias(ParameterSpace<Boolean> hasBias) {
        this.hasBias = hasBias;
    }

    @Override
    public String toString() {
        return "BaseOutputLayerSpace(lossFunction=" + this.getLossFunction() + ", hasBias=" + this.getHasBias() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayerSpace)) {
            return false;
        }
        BaseOutputLayerSpace other = (BaseOutputLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<ILossFunction> this$lossFunction = this.getLossFunction();
        ParameterSpace<ILossFunction> other$lossFunction = other.getLossFunction();
        if (this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction)) {
            return false;
        }
        ParameterSpace<Boolean> this$hasBias = this.getHasBias();
        ParameterSpace<Boolean> other$hasBias = other.getHasBias();
        return !(this$hasBias == null ? other$hasBias != null : !this$hasBias.equals(other$hasBias));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<ILossFunction> $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 43 : $lossFunction.hashCode());
        ParameterSpace<Boolean> $hasBias = this.getHasBias();
        result = result * 59 + ($hasBias == null ? 43 : $hasBias.hashCode());
        return result;
    }

    public BaseOutputLayerSpace() {
    }

    public static abstract class Builder<T>
    extends FeedForwardLayerSpace.Builder<T> {
        protected ParameterSpace<ILossFunction> lossFunction;
        protected ParameterSpace<Boolean> hasBias;

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction((ParameterSpace<LossFunctions.LossFunction>)new FixedValue((Object)lossFunction));
        }

        public T lossFunction(ParameterSpace<LossFunctions.LossFunction> lossFunction) {
            return this.iLossFunction((ParameterSpace<ILossFunction>)new LossFunctionParameterSpaceAdapter(lossFunction));
        }

        public T iLossFunction(ILossFunction lossFunction) {
            return this.iLossFunction((ParameterSpace<ILossFunction>)new FixedValue((Object)lossFunction));
        }

        public T iLossFunction(ParameterSpace<ILossFunction> lossFunction) {
            this.lossFunction = lossFunction;
            return (T)this;
        }

        public T hasBias(boolean hasBias) {
            return this.hasBias((ParameterSpace<Boolean>)new FixedValue((Object)hasBias));
        }

        public T hasBias(ParameterSpace<Boolean> hasBias) {
            this.hasBias = hasBias;
            return (T)this;
        }
    }
}

