/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.BaseOutputLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer;

public class CenterLossOutputLayerSpace
extends BaseOutputLayerSpace<CenterLossOutputLayer> {
    ParameterSpace<Double> alpha;
    ParameterSpace<Double> lambda;

    protected CenterLossOutputLayerSpace(Builder builder) {
        super(builder);
        this.alpha = builder.alpha;
        this.lambda = builder.lambda;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public CenterLossOutputLayer getValue(double[] parameterValues) {
        CenterLossOutputLayer.Builder b = new CenterLossOutputLayer.Builder();
        this.setLayerOptionsBuilder((BaseOutputLayer.Builder)b, parameterValues);
        return b.build();
    }

    protected void setLayerBuilderOptions(CenterLossOutputLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((BaseOutputLayer.Builder)builder, values);
        if (this.alpha != null) {
            builder.alpha(((Double)this.alpha.getValue(values)).doubleValue());
        }
        if (this.lambda != null) {
            builder.lambda(((Double)this.lambda.getValue(values)).doubleValue());
        }
    }

    public ParameterSpace<Double> getAlpha() {
        return this.alpha;
    }

    public ParameterSpace<Double> getLambda() {
        return this.lambda;
    }

    public void setAlpha(ParameterSpace<Double> alpha) {
        this.alpha = alpha;
    }

    public void setLambda(ParameterSpace<Double> lambda) {
        this.lambda = lambda;
    }

    @Override
    public String toString() {
        return "CenterLossOutputLayerSpace(alpha=" + this.getAlpha() + ", lambda=" + this.getLambda() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CenterLossOutputLayerSpace)) {
            return false;
        }
        CenterLossOutputLayerSpace other = (CenterLossOutputLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$alpha = this.getAlpha();
        ParameterSpace<Double> other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !this$alpha.equals(other$alpha)) {
            return false;
        }
        ParameterSpace<Double> this$lambda = this.getLambda();
        ParameterSpace<Double> other$lambda = other.getLambda();
        return !(this$lambda == null ? other$lambda != null : !this$lambda.equals(other$lambda));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CenterLossOutputLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Double> $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : $alpha.hashCode());
        ParameterSpace<Double> $lambda = this.getLambda();
        result = result * 59 + ($lambda == null ? 43 : $lambda.hashCode());
        return result;
    }

    protected CenterLossOutputLayerSpace() {
    }

    public static class Builder
    extends BaseOutputLayerSpace.Builder<Builder> {
        ParameterSpace<Double> alpha;
        ParameterSpace<Double> lambda;

        public Builder alpha(double alpha) {
            return this.alpha((ParameterSpace<Double>)new FixedValue((Object)alpha));
        }

        public Builder alpha(ParameterSpace<Double> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder lambda(double lambda) {
            return this.lambda((ParameterSpace<Double>)new FixedValue((Object)lambda));
        }

        public Builder lambda(ParameterSpace<Double> lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public CenterLossOutputLayerSpace build() {
            return new CenterLossOutputLayerSpace(this);
        }
    }
}

