/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.saver.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.arbiter.DL4JConfiguration;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver;
import org.deeplearning4j.arbiter.saver.local.LocalFileNetResultReference;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModelSaver
implements ResultSaver {
    private static final Logger log = LoggerFactory.getLogger(FileModelSaver.class);
    @JsonProperty
    private String path;
    private File fPath;

    @JsonCreator
    public FileModelSaver(@NonNull String path) {
        this(new File(path));
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
    }

    public FileModelSaver(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        this.path = file.getPath();
        this.fPath = file;
        if (!this.fPath.exists()) {
            this.fPath.mkdirs();
        } else if (!this.fPath.isDirectory()) {
            throw new IllegalArgumentException("Invalid path: exists and is not directory. " + this.path);
        }
        log.info("FileModelSaver saving networks to local directory: {}", (Object)this.path);
    }

    public ResultReference saveModel(OptimizationResult result, Object modelResult) throws IOException {
        int nEpochs;
        EarlyStoppingConfiguration<ComputationGraph> esc;
        Serializable c;
        String dir = new File(this.path, result.getIndex() + "/").getAbsolutePath();
        File f = new File(dir);
        f.mkdir();
        File modelFile = new File(FilenameUtils.concat((String)dir, (String)"model.bin"));
        File scoreFile = new File(FilenameUtils.concat((String)dir, (String)"score.txt"));
        File additionalResultsFile = new File(FilenameUtils.concat((String)dir, (String)"additionalResults.bin"));
        File esConfigFile = new File(FilenameUtils.concat((String)dir, (String)"earlyStoppingConfig.bin"));
        File numEpochsFile = new File(FilenameUtils.concat((String)dir, (String)"numEpochs.txt"));
        FileUtils.writeStringToFile((File)scoreFile, (String)String.valueOf(result.getScore()));
        Model m = (Model)modelResult;
        ModelSerializer.writeModel((Model)m, (File)modelFile, (boolean)true);
        Object additionalResults = result.getModelSpecificResults();
        if (additionalResults != null && additionalResults instanceof Serializable) {
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(additionalResultsFile));){
                oos.writeObject(additionalResults);
            }
        }
        if (result.getCandidate().getValue() instanceof DL4JConfiguration) {
            c = (DL4JConfiguration)result.getCandidate().getValue();
            esc = ((DL4JConfiguration)c).getEarlyStoppingConfiguration();
            nEpochs = ((DL4JConfiguration)c).getNumEpochs();
        } else {
            c = (GraphConfiguration)result.getCandidate().getValue();
            esc = ((GraphConfiguration)c).getEarlyStoppingConfiguration();
            nEpochs = ((GraphConfiguration)c).getNumEpochs();
        }
        if (esc != null) {
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(esConfigFile));){
                oos.writeObject(esc);
            }
        } else {
            FileUtils.writeStringToFile((File)numEpochsFile, (String)String.valueOf(nEpochs));
        }
        log.debug("Deeplearning4j model result (id={}, score={}) saved to directory: {}", new Object[]{result.getIndex(), result.getScore(), dir});
        boolean isGraph = m instanceof ComputationGraph;
        return new LocalFileNetResultReference(result.getIndex(), dir, isGraph, modelFile, scoreFile, additionalResultsFile, esConfigFile, numEpochsFile, (Candidate<DL4JConfiguration>)result.getCandidate());
    }

    public List<Class<?>> getSupportedCandidateTypes() {
        return Collections.singletonList(Object.class);
    }

    public List<Class<?>> getSupportedModelTypes() {
        return Arrays.asList(MultiLayerNetwork.class, ComputationGraph.class);
    }

    public String toString() {
        return "FileModelSaver(path=" + this.path + ")";
    }

    public FileModelSaver() {
    }

    public FileModelSaver(String path, File fPath) {
        this.path = path;
        this.fPath = fPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileModelSaver)) {
            return false;
        }
        FileModelSaver other = (FileModelSaver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        File this$fPath = this.fPath;
        File other$fPath = other.fPath;
        return !(this$fPath == null ? other$fPath != null : !((Object)this$fPath).equals(other$fPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileModelSaver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        File $fPath = this.fPath;
        result = result * 59 + ($fPath == null ? 43 : ((Object)$fPath).hashCode());
        return result;
    }
}

