/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring.impl;

import lombok.NonNull;
import org.deeplearning4j.arbiter.scoring.impl.BaseNetScoreFunction;
import org.deeplearning4j.datasets.iterator.MultiDataSetWrapperIterator;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.evaluation.classification.Evaluation;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class EvaluationScoreFunction
extends BaseNetScoreFunction {
    protected Evaluation.Metric metric;

    public EvaluationScoreFunction(@NonNull Evaluation.Metric metric) {
        this(metric.toNd4j());
        if (metric == null) {
            throw new NullPointerException("metric is marked @NonNull but is null");
        }
    }

    public EvaluationScoreFunction(@NonNull Evaluation.Metric metric) {
        if (metric == null) {
            throw new NullPointerException("metric is marked @NonNull but is null");
        }
        this.metric = metric;
    }

    public String toString() {
        return "EvaluationScoreFunction(metric=" + this.metric + ")";
    }

    @Override
    public double score(MultiLayerNetwork net, DataSetIterator iterator) {
        Evaluation e = net.evaluate(iterator);
        return e.scoreForMetric(this.metric);
    }

    @Override
    public double score(MultiLayerNetwork net, MultiDataSetIterator iterator) {
        return this.score(net, (DataSetIterator)new MultiDataSetWrapperIterator(iterator));
    }

    @Override
    public double score(ComputationGraph graph, DataSetIterator iterator) {
        Evaluation e = graph.evaluate(iterator);
        return e.scoreForMetric(this.metric);
    }

    @Override
    public double score(ComputationGraph graph, MultiDataSetIterator iterator) {
        Evaluation e = graph.evaluate(iterator);
        return e.scoreForMetric(this.metric);
    }

    public boolean minimize() {
        return false;
    }

    public Evaluation.Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Evaluation.Metric metric) {
        this.metric = metric;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluationScoreFunction)) {
            return false;
        }
        EvaluationScoreFunction other = (EvaluationScoreFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Evaluation.Metric this$metric = this.getMetric();
        Evaluation.Metric other$metric = other.getMetric();
        return !(this$metric == null ? other$metric != null : !this$metric.equals(other$metric));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EvaluationScoreFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Evaluation.Metric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        return result;
    }

    protected EvaluationScoreFunction() {
    }
}

