/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Broadcast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseBroadcastOp
extends BaseOp
implements BroadcastOp {
    private static final Logger log = LoggerFactory.getLogger(BaseBroadcastOp.class);
    protected int[] dimension;

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension) {
        this(sameDiff, i_v1, i_v2, false, dimension);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace, int[] dimension) {
        super(sameDiff, inPlace, new Object[]{i_v2});
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        this.inPlace = inPlace;
        this.dimension = dimension;
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension, Object[] extraArgs) {
        super(sameDiff, extraArgs);
        this.dimension = dimension;
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, dimension, null);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, int[] dimension, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        this.dimension = dimension;
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v);
        sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, Object[] extraArgs) {
        this(sameDiff, i_v, i_v.getShape(), false, dimension, extraArgs);
    }

    public BaseBroadcastOp(INDArray x, INDArray y, INDArray z, int ... dimension) {
        super(x, y, z);
        Broadcast.validateBroadcastDims(x, y, z, dimension);
        this.dimension = dimension;
        this.defineDimensions(dimension);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.BROADCAST;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null || this.y == null) {
            return Collections.emptyList();
        }
        long[] shapeX = this.x.shape();
        long[] shapeY = this.y.shape();
        return Collections.singletonList(LongShapeDescriptor.fromShape(Shape.broadcastOutputShape(shapeX, shapeY), Shape.pickPairwiseDataType(this.x.dataType(), this.y.dataType())));
    }

    @Override
    public int[] getDimension() {
        if (this.dimension == null) {
            this.dimension = Shape.getBroadcastDimensions(this.larg().getShape(), this.rarg().getShape());
        }
        return this.dimension;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.dimension = dimension;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        int op = this.opNum();
        if (this.y() != null && this.z() != null) {
            Preconditions.checkArgument((this.y().dataType() == this.z().dataType() || this.x().dataType() == this.z().dataType() ? 1 : 0) != 0, (String)"Op.Z type must be either Op.X or Op.Y: x.dataType=%s, y.dataType=%s, z.dataType=%s, op=%s", (Object)this.x.dataType(), (Object)this.y.dataType(), (Object)this.z.dataType(), (Object)this.getClass().getName());
        }
        if (!experimentalMode) {
            Preconditions.checkArgument((this.x.dataType() == this.y.dataType() || this.y.dataType() == DataType.BOOL ? 1 : 0) != 0, (String)"Op.X must have same data type as Op.Y: X.datatype=%s, Y.datatype=%s", (Object)this.x.dataType(), (Object)this.y.dataType());
        }
        if (this.y() != null) {
            if (op != 1 && (this.y().isR() || this.x().isR())) {
                Preconditions.checkArgument((boolean)this.z().isR(), (String)"Op.Z must have floating point type, since one of operands is floating point: x.dataType=%s, y.dataType=%s, z.dataType=%s, op=%s", (Object)this.x.dataType(), (Object)this.y.dataType(), (Object)this.z.dataType(), (Object)this.getClass().getName());
            }
        } else if (this.x().isR()) {
            Preconditions.checkArgument((boolean)this.z().isR(), (String)"Op.Z must have floating point type, since one of operands is floating point: x.dataType=%s, z.dataType=%s, op=%s", (Object)this.x.dataType(), (Object)this.z.dataType(), (Object)this.getClass().getName());
        }
        return true;
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.BROADCAST;
    }

    public BaseBroadcastOp() {
    }
}

